/*
 * Decompiled with CFR 0.152.
 */
package xdean.jex.util.lang;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xdean.jex.extra.Either;
import xdean.jex.extra.Wrapper;
import xdean.jex.extra.function.RunnableThrow;
import xdean.jex.extra.function.SupplierThrow;
import xdean.jex.util.function.FunctionAdapter;

public class ExceptionUtil {
    private static final Logger log = LoggerFactory.getLogger(ExceptionUtil.class);

    public static <T extends Throwable, R> R throwIt(T t) throws T {
        throw t;
    }

    public static <T extends Throwable> void throwAsUncheck(Throwable t) throws T {
        throw t;
    }

    public static void uncheck(RunnableThrow<?> task) {
        try {
            task.run();
        }
        catch (Throwable t) {
            ExceptionUtil.throwAsUncheck(t);
        }
    }

    public static <T> T uncheck(SupplierThrow<T, ?> task) {
        return FunctionAdapter.supplierToRunnable(task, r -> ExceptionUtil.uncheck(r));
    }

    public static boolean uncatch(RunnableThrow<?> task) {
        try {
            task.run();
            return true;
        }
        catch (Throwable t) {
            log.trace("Dont catch", t);
            return false;
        }
    }

    public static <T> T uncatch(SupplierThrow<T, ?> task) {
        return FunctionAdapter.supplierToRunnable(task, r -> ExceptionUtil.uncatch(r));
    }

    public static <E extends Throwable> Optional<E> throwToReturn(RunnableThrow<E> task) {
        try {
            task.run();
        }
        catch (Throwable t) {
            try {
                return Optional.of(t);
            }
            catch (ClassCastException cce) {
                throw new RuntimeException("An unexcepted exception thrown.", t);
            }
        }
        return Optional.empty();
    }

    public static <T, E extends Exception> Either<T, E> throwToReturn(SupplierThrow<T, E> task) {
        Wrapper<Object> w = new Wrapper<Object>(null);
        return Either.rightOrDefault(ExceptionUtil.throwToReturn(() -> w.set(task.get())), w.get());
    }

    public static String getStackTraceString(Throwable tr) {
        if (tr == null) {
            return "";
        }
        Throwable t = tr;
        while (t.getCause() != null) {
            t = t.getCause();
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        pw.flush();
        return sw.toString();
    }
}

