/*
 * Decompiled with CFR 0.152.
 */
package xdean.jex.util.lang;

import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import xdean.jex.util.reflect.ReflectUtil;

public class FinalizeSupport {
    private static Map<Reference<?>, Runnable> map;
    private static ReferenceQueue<Object> queue;
    private static Object lock;

    public static void finalize(Object o, Runnable r) {
        map.put(new PhantomReference<Object>(o, queue), r);
    }

    static {
        ThreadGroup tg;
        map = new ConcurrentHashMap();
        queue = new ReferenceQueue();
        try {
            lock = ReflectUtil.getFieldValue(ReferenceQueue.class, queue, "lock");
        }
        catch (NoSuchFieldException e) {
            throw new Error("Can't find ReferenceQueue's lock, Check code and java version");
        }
        ThreadGroup tgn = tg = Thread.currentThread().getThreadGroup();
        while (tgn != null) {
            tg = tgn;
            tgn = tg.getParent();
        }
        FinalizeHandler handler = new FinalizeHandler(tg, "Finalize Support");
        handler.setPriority(10);
        handler.setDaemon(true);
        handler.start();
    }

    private static class FinalizeHandler
    extends Thread {
        public FinalizeHandler(ThreadGroup tg, String name) {
            super(tg, name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            Object object = lock;
            synchronized (object) {
                while (!Thread.interrupted()) {
                    Reference ref = queue.poll();
                    if (ref == null) {
                        try {
                            lock.wait();
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                        continue;
                    }
                    Optional.ofNullable(map.remove(ref)).ifPresent(r -> r.run());
                }
                return;
            }
        }
    }
}

