/*
 * Decompiled with CFR 0.152.
 */
package xdean.jex.util.lang;

import java.util.HashMap;
import java.util.Map;

public class PrimitiveTypeUtil {
    private static final Map<Class<?>, Class<?>> primitiveToWrappers = new HashMap();
    private static final Map<Class<?>, Class<?>> wrappersToPrimitives = new HashMap();

    public static Class<?> toWrapper(Class<?> primitiveType) {
        return primitiveToWrappers.get(primitiveType);
    }

    public static Class<?> toPrimitive(Class<?> wrapperType) {
        return wrappersToPrimitives.get(wrapperType);
    }

    public static boolean isPrimitive(Class<?> clz) {
        return primitiveToWrappers.keySet().contains(clz);
    }

    public static boolean isWrapper(Class<?> clz) {
        return wrappersToPrimitives.keySet().contains(clz);
    }

    public static int sizeOf(Class<?> clz) throws IllegalArgumentException {
        switch (clz.getName()) {
            case "int": {
                return 4;
            }
            case "short": {
                return 2;
            }
            case "long": {
                return 8;
            }
            case "double": {
                return 8;
            }
            case "float": {
                return 4;
            }
            case "boolean": {
                return 1;
            }
            case "char": {
                return 2;
            }
            case "byte": {
                return 1;
            }
        }
        throw new IllegalArgumentException("Not a primitive type.");
    }

    public static <T> T parse(Class<T> clz, String objectValue) {
        switch (clz.getName()) {
            case "int": {
                return (T)Integer.valueOf(objectValue);
            }
            case "short": {
                return (T)Short.valueOf(objectValue);
            }
            case "long": {
                if (objectValue.endsWith("L") || objectValue.endsWith("l")) {
                    objectValue = objectValue.substring(0, objectValue.length() - 1);
                }
                return (T)Long.valueOf(objectValue);
            }
            case "double": {
                return (T)Double.valueOf(objectValue);
            }
            case "float": {
                return (T)Float.valueOf(objectValue);
            }
            case "boolean": {
                if (objectValue.equalsIgnoreCase(Boolean.TRUE.toString())) {
                    return (T)Boolean.TRUE;
                }
                if (objectValue.equalsIgnoreCase(Boolean.FALSE.toString())) {
                    return (T)Boolean.FALSE;
                }
                throw new IllegalArgumentException(String.format("The String %s cannot parse as boolean.", objectValue));
            }
            case "char": {
                if (objectValue.length() == 1) {
                    return (T)new Character(objectValue.charAt(0));
                }
                throw new IllegalArgumentException(String.format("The String %s cannot parse as char.", objectValue));
            }
            case "byte": {
                return (T)Byte.valueOf(objectValue);
            }
        }
        return null;
    }

    private static void add(Class<?> primitiveType, Class<?> wrapperType) {
        primitiveToWrappers.put(primitiveType, wrapperType);
        wrappersToPrimitives.put(wrapperType, primitiveType);
    }

    static {
        PrimitiveTypeUtil.add(Boolean.TYPE, Boolean.class);
        PrimitiveTypeUtil.add(Byte.TYPE, Byte.class);
        PrimitiveTypeUtil.add(Character.TYPE, Character.class);
        PrimitiveTypeUtil.add(Double.TYPE, Double.class);
        PrimitiveTypeUtil.add(Float.TYPE, Float.class);
        PrimitiveTypeUtil.add(Integer.TYPE, Integer.class);
        PrimitiveTypeUtil.add(Long.TYPE, Long.class);
        PrimitiveTypeUtil.add(Short.TYPE, Short.class);
        PrimitiveTypeUtil.add(Void.TYPE, Void.class);
    }
}

