/*
 * Decompiled with CFR 0.152.
 */
package xdean.jex.util.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import xdean.jex.util.lang.ExceptionUtil;

public class AnnotationUtil {
    public static final Constructor<?> AnnotationInvocationHandler_constructor;
    public static final Constructor<?> AnnotationData_constructor;
    public static final Method Class_annotationData;
    public static final Field Class_classRedefinedCount;
    public static final Field AnnotationData_annotations;
    public static final Field AnnotationData_declaredAnotations;
    public static final Method Atomic_casAnnotationData;
    public static final Class<?> Atomic_class;
    public static final Field Field_Excutable_DeclaredAnnotations;
    public static final Field Field_Field_DeclaredAnnotations;

    public static Object changeAnnotationValue(Annotation annotation, String key, Object newValue) {
        Map memberValues;
        Field f;
        InvocationHandler handler = Proxy.getInvocationHandler(annotation);
        try {
            f = handler.getClass().getDeclaredField("memberValues");
        }
        catch (NoSuchFieldException | SecurityException e) {
            throw new IllegalStateException(e);
        }
        f.setAccessible(true);
        try {
            memberValues = (Map)f.get(handler);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new IllegalStateException(e);
        }
        Object oldValue = memberValues.get(key);
        if (oldValue == null || oldValue.getClass() != newValue.getClass()) {
            throw new IllegalArgumentException();
        }
        memberValues.put(key, newValue);
        return oldValue;
    }

    public static void addAnnotation(Executable ex, Annotation annotation) {
        HashMap<Class<? extends Annotation>, Annotation> annos;
        ex.getAnnotation(Annotation.class);
        try {
            annos = (HashMap<Class<? extends Annotation>, Annotation>)Field_Excutable_DeclaredAnnotations.get(ex);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        if (annos.getClass() == Collections.EMPTY_MAP.getClass()) {
            annos = new HashMap<Class<? extends Annotation>, Annotation>();
            try {
                Field_Excutable_DeclaredAnnotations.set(ex, annos);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
        }
        annos.put(annotation.annotationType(), annotation);
    }

    public static void addAnnotation(Field field, Annotation annotation) {
        HashMap<Class<? extends Annotation>, Annotation> annos;
        field.getAnnotation(Annotation.class);
        try {
            annos = (HashMap<Class<? extends Annotation>, Annotation>)Field_Field_DeclaredAnnotations.get(field);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        if (annos.getClass() == Collections.EMPTY_MAP.getClass()) {
            annos = new HashMap<Class<? extends Annotation>, Annotation>();
            try {
                Field_Field_DeclaredAnnotations.set(field, annos);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
        }
        annos.put(annotation.annotationType(), annotation);
    }

    public static void addAnnotation(Class<?> c, Annotation annotation) {
        try {
            Object newAnnotationData;
            Object annotationData;
            do {
                int classRedefinedCount = Class_classRedefinedCount.getInt(c);
                annotationData = Class_annotationData.invoke(c, new Object[0]);
                newAnnotationData = AnnotationUtil.createAnnotationData(c, annotationData, annotation, classRedefinedCount);
            } while (!((Boolean)Atomic_casAnnotationData.invoke(Atomic_class, c, annotationData, newAnnotationData)).booleanValue());
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    public static Object createAnnotationData(Class<?> c, Object annotationData, Annotation annotation, int classRedefinedCount) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        LinkedHashMap<Class<? extends Annotation>, Annotation> newAnnotations;
        Map annotations = (Map)AnnotationData_annotations.get(annotationData);
        Map declaredAnnotations = (Map)AnnotationData_declaredAnotations.get(annotationData);
        LinkedHashMap<Class<? extends Annotation>, Annotation> newDeclaredAnnotations = new LinkedHashMap<Class<? extends Annotation>, Annotation>(annotations);
        newDeclaredAnnotations.put(annotation.annotationType(), annotation);
        if (declaredAnnotations == annotations) {
            newAnnotations = newDeclaredAnnotations;
        } else {
            newAnnotations = new LinkedHashMap(annotations);
            newAnnotations.put(annotation.annotationType(), annotation);
        }
        return AnnotationData_constructor.newInstance(newAnnotations, newDeclaredAnnotations, classRedefinedCount);
    }

    public static <T extends Annotation> T createAnnotationFromMap(Class<T> annotationClass, Map<String, Object> valuesMap) {
        return (T)AccessController.doPrivileged(() -> (Annotation)Proxy.newProxyInstance(annotationClass.getClassLoader(), new Class[]{annotationClass}, ExceptionUtil.uncheck(() -> (InvocationHandler)AnnotationInvocationHandler_constructor.newInstance(annotationClass, new HashMap(valuesMap)))));
    }

    static {
        try {
            Class<?> AnnotationInvocationHandler_class = Class.forName("sun.reflect.annotation.AnnotationInvocationHandler");
            AnnotationInvocationHandler_constructor = AnnotationInvocationHandler_class.getDeclaredConstructor(Class.class, Map.class);
            AnnotationInvocationHandler_constructor.setAccessible(true);
            Atomic_class = Class.forName("java.lang.Class$Atomic");
            Class<?> AnnotationData_class = Class.forName("java.lang.Class$AnnotationData");
            AnnotationData_constructor = AnnotationData_class.getDeclaredConstructor(Map.class, Map.class, Integer.TYPE);
            AnnotationData_constructor.setAccessible(true);
            Class_annotationData = Class.class.getDeclaredMethod("annotationData", new Class[0]);
            Class_annotationData.setAccessible(true);
            Class_classRedefinedCount = Class.class.getDeclaredField("classRedefinedCount");
            Class_classRedefinedCount.setAccessible(true);
            AnnotationData_annotations = AnnotationData_class.getDeclaredField("annotations");
            AnnotationData_annotations.setAccessible(true);
            AnnotationData_declaredAnotations = AnnotationData_class.getDeclaredField("declaredAnnotations");
            AnnotationData_declaredAnotations.setAccessible(true);
            Atomic_casAnnotationData = Atomic_class.getDeclaredMethod("casAnnotationData", Class.class, AnnotationData_class, AnnotationData_class);
            Atomic_casAnnotationData.setAccessible(true);
            Field_Excutable_DeclaredAnnotations = Executable.class.getDeclaredField("declaredAnnotations");
            Field_Excutable_DeclaredAnnotations.setAccessible(true);
            Field_Field_DeclaredAnnotations = Field.class.getDeclaredField("declaredAnnotations");
            Field_Field_DeclaredAnnotations.setAccessible(true);
        }
        catch (ClassNotFoundException | NoSuchFieldException | NoSuchMethodException | SecurityException e) {
            throw new IllegalStateException("AnnotationUtil init fail, check your java version.", e);
        }
    }
}

