/*
 * Decompiled with CFR 0.152.
 */
package xdean.jex.util.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xdean.jex.util.lang.ExceptionUtil;

public class ReflectUtil {
    private static final Logger log = LoggerFactory.getLogger(ReflectUtil.class);
    public static final UnaryOperator<Method> METHOD_GET_ROOT;
    public static final Function<Class<?>, Method[]> CLASS_GET_ROOT_METHODS;
    public static final UnaryOperator<Field> FIELD_GET_ROOT;
    public static final Function<Class<?>, Field[]> CLASS_GET_ROOT_FIELDS;

    public static Method getRootMethod(Method m) {
        return (Method)METHOD_GET_ROOT.apply(m);
    }

    public static Method[] getRootMethods(Class<?> clz) {
        return CLASS_GET_ROOT_METHODS.apply(clz);
    }

    public static Field getRootField(Field f) {
        return (Field)FIELD_GET_ROOT.apply(f);
    }

    public static Field[] getRootFields(Class<?> clz) {
        return CLASS_GET_ROOT_FIELDS.apply(clz);
    }

    public static <T, O> O getFieldValue(Class<T> clz, T t, String fieldName) throws NoSuchFieldException {
        Field field = clz.getDeclaredField(fieldName);
        field.setAccessible(true);
        try {
            return (O)field.get(t);
        }
        catch (IllegalAccessException e) {
            log.error("Should not happen.", (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    public static Field[] getAllFields(Class<?> clz, boolean includeStatic) {
        ArrayList list = new ArrayList();
        do {
            list.addAll(Arrays.asList(clz.getDeclaredFields()).stream().filter(f -> includeStatic || !Modifier.isStatic(f.getModifiers())).collect(Collectors.toList()));
        } while ((clz = clz.getSuperclass()) != null);
        return list.toArray(new Field[list.size()]);
    }

    public static String getCallerClassName() {
        return ReflectUtil.getCaller().getClassName();
    }

    public static StackTraceElement getCaller() {
        return ReflectUtil.getCaller(1, true);
    }

    public static StackTraceElement getCaller(int deep, boolean ignoreSameClass) {
        StackTraceElement[] stElements = Thread.currentThread().getStackTrace();
        StackTraceElement currentStack = stElements[1];
        int found = deep + 1;
        for (int i = 1; i < stElements.length; ++i) {
            StackTraceElement nextStack = stElements[i];
            if (nextStack.getClassName() == ReflectUtil.class.getName()) continue;
            if (!ignoreSameClass || !currentStack.getClassName().equals(nextStack.getClassName())) {
                currentStack = nextStack;
                --found;
            }
            if (found != 0) continue;
            return currentStack;
        }
        return null;
    }

    static {
        try {
            Method getRootMethod = Method.class.getDeclaredMethod("getRoot", new Class[0]);
            getRootMethod.setAccessible(true);
            METHOD_GET_ROOT = m -> ExceptionUtil.uncheck(() -> (Method)getRootMethod.invoke(m, new Object[0]));
            Method getRootMethods = Class.class.getDeclaredMethod("privateGetPublicMethods", new Class[0]);
            getRootMethods.setAccessible(true);
            CLASS_GET_ROOT_METHODS = c -> ExceptionUtil.uncheck(() -> (Method[])getRootMethods.invoke(c, new Object[0]));
            Field getRootField = Field.class.getDeclaredField("root");
            getRootField.setAccessible(true);
            FIELD_GET_ROOT = f -> ExceptionUtil.uncheck(() -> (Field)getRootField.get(f));
            Method getRootFields = Class.class.getDeclaredMethod("privateGetPublicMethods", new Class[0]);
            getRootFields.setAccessible(true);
            CLASS_GET_ROOT_FIELDS = c -> ExceptionUtil.uncheck(() -> (Field[])getRootFields.invoke(c, new Object[0]));
        }
        catch (NoSuchFieldException | NoSuchMethodException | SecurityException e) {
            throw new IllegalStateException("ReflectUtil init fail, check your java version.", e);
        }
    }
}

