/*
 * Decompiled with CFR 0.152.
 */
package xdean.jex.util.task;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import rx.Observable;
import rx.schedulers.Schedulers;
import xdean.jex.extra.function.RunnableThrow;
import xdean.jex.extra.function.SupplierThrow;
import xdean.jex.util.lang.ExceptionUtil;

public class TaskUtil {
    public static void async(Runnable task) {
        Observable.just((Object)task).observeOn(Schedulers.newThread()).subscribe(r -> r.run());
    }

    public static void todoAll(Runnable ... tasks) {
        for (Runnable task : tasks) {
            task.run();
        }
    }

    @SafeVarargs
    public static <T> T firstSuccess(SupplierThrow<T, ?> ... tasks) {
        for (SupplierThrow<?, ?> supplierThrow : tasks) {
            T result = ExceptionUtil.uncatch(supplierThrow);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @SafeVarargs
    public static <T extends Throwable> Optional<T> firstFail(RunnableThrow<T> ... tasks) {
        for (RunnableThrow<T> task : tasks) {
            try {
                task.run();
            }
            catch (Throwable t) {
                try {
                    return Optional.of(t);
                }
                catch (ClassCastException cce) {
                    throw new RuntimeException("An unexcepted exception thrown.", t);
                }
            }
        }
        return Optional.empty();
    }

    public static void andFinal(Runnable task, Runnable then) {
        try {
            task.run();
        }
        finally {
            then.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T andFinal(Supplier<T> task, Consumer<T> then) {
        Object t = null;
        try {
            T t2 = task.get();
            t = t2;
            T t3 = t2;
            return t3;
        }
        finally {
            then.accept(t);
        }
    }
}

