/*
 * Decompiled with CFR 0.152.
 */
package xdean.jex.util.task.tryto;

import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import xdean.jex.util.task.tryto.Failure;
import xdean.jex.util.task.tryto.Try;

public class Success<T>
extends Try<T> {
    private final T value;

    Success(T value) {
        this.value = value;
    }

    @Override
    public boolean isFailure() {
        return false;
    }

    @Override
    public boolean isSuccess() {
        return true;
    }

    @Override
    public T get() {
        return this.value;
    }

    @Override
    public Try<T> foreach(Consumer<T> f) {
        f.accept(this.value);
        return this;
    }

    @Override
    public <U> Try<U> flatMap(Function<T, Try<U>> f) {
        try {
            return f.apply(this.value);
        }
        catch (Exception e) {
            return new Failure(e);
        }
    }

    @Override
    public <U> Try<U> map(Function<T, U> f) {
        return Try.to(() -> f.apply(this.value));
    }

    @Override
    public Try<T> filter(Predicate<T> p) {
        try {
            if (p.test(this.value)) {
                return this;
            }
            return new Failure(new NoSuchElementException("Predicate does not hold for " + this.value));
        }
        catch (Exception e) {
            return new Failure(e);
        }
    }

    @Override
    public Try<T> recoverWith(Function<Exception, Try<T>> f) {
        return this;
    }

    @Override
    public Try<T> recover(Function<Exception, T> f) {
        return this;
    }

    @Override
    public Try<Exception> failed() {
        return new Failure<Exception>(new UnsupportedOperationException("Success.failed"));
    }

    @Override
    public <U> Try<U> transform(Function<T, Try<U>> s, Function<Exception, Try<U>> f) {
        try {
            return s.apply(this.get());
        }
        catch (RuntimeException e) {
            return new Failure(e);
        }
    }

    @Override
    public Try<T> onException(Consumer<Exception> f) {
        return this;
    }
}

