/*
 * Decompiled with CFR 0.152.
 */
package xdean.jex.util.task.tryto;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xdean.jex.extra.function.RunnableThrow;
import xdean.jex.extra.function.SupplierThrow;
import xdean.jex.util.task.tryto.Failure;
import xdean.jex.util.task.tryto.Success;

public abstract class Try<T> {
    private static final Logger LOG = LoggerFactory.getLogger(Try.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> Try<T> to(SupplierThrow<T, Exception> code, RunnableThrow<Exception> onFinally) {
        try {
            Success<T> success = new Success<T>(code.get());
            return success;
        }
        catch (Exception e) {
            Failure failure = new Failure(e);
            return failure;
        }
        finally {
            if (onFinally != null) {
                try {
                    onFinally.run();
                }
                catch (Exception e) {
                    LOG.debug(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public static <T> Try<T> to(SupplierThrow<T, Exception> code) {
        return Try.to(code, null);
    }

    public static Try<Void> to(RunnableThrow<Exception> code, RunnableThrow<Exception> onFinally) {
        return Try.to(() -> {
            code.run();
            return null;
        }, onFinally);
    }

    public static Try<Void> to(RunnableThrow<Exception> code) {
        return Try.to(code, null);
    }

    public static <T> Try<T> of(T value) {
        return new Success<T>(value);
    }

    public static <T extends Exception> Try<T> ofFailure(T value) {
        return new Failure(value);
    }

    public abstract boolean isFailure();

    public abstract boolean isSuccess();

    public T getOrElse(Supplier<T> defaultValue) {
        return this.isSuccess() ? this.get() : defaultValue.get();
    }

    public T getOrElse(T defaultValue) {
        return this.isSuccess() ? this.get() : defaultValue;
    }

    public Try<T> orElse(Supplier<Try<T>> defaultValue) {
        try {
            return this.isSuccess() ? this : defaultValue.get();
        }
        catch (RuntimeException e) {
            return new Failure(e);
        }
    }

    public Try<T> orElse(Try<T> defaultValue) {
        try {
            return this.isSuccess() ? this : defaultValue;
        }
        catch (RuntimeException e) {
            return new Failure(e);
        }
    }

    public abstract T get();

    public abstract Try<T> foreach(Consumer<T> var1);

    public abstract Try<T> onException(Consumer<Exception> var1);

    public abstract <U> Try<U> flatMap(Function<T, Try<U>> var1);

    public abstract <U> Try<U> map(Function<T, U> var1);

    public abstract Try<T> filter(Predicate<T> var1);

    public abstract Try<T> recoverWith(Function<Exception, Try<T>> var1);

    public abstract Try<T> recover(Function<Exception, T> var1);

    public Optional<T> toOptional() {
        return this.isSuccess() ? Optional.ofNullable(this.get()) : Optional.empty();
    }

    public abstract Try<Exception> failed();

    public abstract <U> Try<U> transform(Function<T, Try<U>> var1, Function<Exception, Try<U>> var2);
}

