/*
 * Decompiled with CFR 0.152.
 */
package xdean.jex.extra;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import xdean.jex.extra.Left;
import xdean.jex.extra.Right;

public interface Either<L, R> {
    public static <L, R> Either<L, R> left(L l) {
        return new Left(l);
    }

    public static <L, R> Either<L, R> right(R r) {
        return new Right(r);
    }

    public static <L, R> Either<L, R> leftOrNull(Optional<L> l) {
        return Either.leftOrDefault(l, null);
    }

    public static <L, R> Either<L, R> rightOrNull(Optional<R> r) {
        return Either.rightOrDefault(r, null);
    }

    public static <L, R> Either<L, R> leftOrDefault(Optional<L> l, R r) {
        return l.isPresent() ? Either.left(l.get()) : Either.right(r);
    }

    public static <L, R> Either<L, R> rightOrDefault(Optional<R> r, L l) {
        return r.isPresent() ? Either.right(r.get()) : Either.left(l);
    }

    public boolean isLeft();

    public boolean isRight();

    public L getLeft();

    public R getRight();

    public L toLeft(Function<? super R, ? extends L> var1);

    public R toRight(Function<? super L, ? extends R> var1);

    public Optional<L> asLeft();

    public Optional<R> asRight();

    public Either<L, R> ifLeft(Consumer<? super L> var1);

    public Either<L, R> ifRight(Consumer<? super R> var1);

    public void exec(Consumer<? super L> var1, Consumer<? super R> var2);

    public <L2> Either<L2, R> mapLeft(Function<? super L, ? extends L2> var1);

    public <R2> Either<L, R2> mapRight(Function<? super R, ? extends R2> var1);

    public <L2, R2> Either<L2, R2> map(Function<? super L, ? extends L2> var1, Function<? super R, ? extends R2> var2);

    public <L2, R2> Either<L2, R2> flatMap(Function<? super L, Either<L2, R2>> var1, Function<? super R, Either<L2, R2>> var2);

    public <L2> Either<L2, R> flatMapLeft(Function<? super L, Either<L2, R>> var1);

    public <R2> Either<L, R2> flatMapRight(Function<? super R, Either<L, R2>> var1);

    public <T> T unify(Function<? super L, ? extends T> var1, Function<? super R, ? extends T> var2);
}

