/*
 * Decompiled with CFR 0.152.
 */
package xdean.jex.extra;

import java.util.Objects;

public class Pair<K, V> {
    private static final Pair<?, ?> EMPTY = new Pair<Object, Object>(null, null);
    private final K left;
    private final V right;

    public static <K, V> Pair<K, V> of(K k, V v) {
        return new Pair<K, V>(k, v);
    }

    public static <K, V> Pair<K, V> empty() {
        return EMPTY;
    }

    public Pair(K k, V v) {
        this.left = k;
        this.right = v;
    }

    public K getLeft() {
        return this.left;
    }

    public V getRight() {
        return this.right;
    }

    public <L> Pair<L, V> left(L left) {
        return Pair.of(left, this.right);
    }

    public <R> Pair<K, R> right(R right) {
        return Pair.of(this.left, right);
    }

    public int hashCode() {
        return Objects.hash(this.left, this.right);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Pair)) {
            return false;
        }
        Pair other = (Pair)obj;
        return Objects.equals(this.left, other.left) && Objects.equals(this.right, other.right);
    }

    public String toString() {
        return "Pair [left=" + this.left + ", right=" + this.right + "]";
    }
}

