/*
 * Decompiled with CFR 0.152.
 */
package xdean.jex.extra.collection;

import java.util.AbstractList;
import java.util.Arrays;

public class FixedLengthList<T>
extends AbstractList<T> {
    protected final int length;
    protected final T[] array;
    protected int pos;
    protected int count;

    public FixedLengthList(int length) {
        this.length = length;
        this.array = new Object[length];
    }

    @Override
    public int size() {
        return this.count >= this.length ? this.length : this.pos;
    }

    @Override
    public T get(int index) {
        return this.count >= this.length ? this.array[(this.pos + index) % this.length] : this.array[index];
    }

    @Override
    public boolean add(T t) {
        this.array[this.pos] = t;
        this.pos = (this.pos + 1) % this.length;
        ++this.count;
        return true;
    }

    @Override
    public Object[] toArray() {
        Object[] buffer;
        if (this.array[this.pos] == null) {
            buffer = Arrays.copyOf(this.array, this.pos);
        } else {
            buffer = new Object[this.length];
            System.arraycopy(this.array, this.pos, buffer, 0, this.length - this.pos);
            System.arraycopy(this.array, 0, buffer, this.length - this.pos, this.pos);
        }
        return buffer;
    }
}

