/*
 * Decompiled with CFR 0.152.
 */
package xdean.jex.extra.collection;

import java.util.AbstractList;
import java.util.Comparator;
import xdean.jex.extra.collection.LinkedList;

public class LinkedMonotoneList<E>
extends AbstractList<E> {
    private Comparator<E> compartor;
    private LinkedList<E> list = new LinkedList();
    private MonoType type;

    public LinkedMonotoneList(Comparator<E> comp, MonoType type) {
        this.compartor = comp;
        this.type = type;
    }

    @Override
    public boolean add(E e) {
        if (this.type == MonoType.INSERT) {
            LinkedList.Node node = this.list.last;
            while (this.compartor.compare(node.item, e) > 0) {
                node = node.prev;
            }
            if (node == this.list.last) {
                this.list.linkLast(e);
            } else {
                this.list.linkBefore(e, node.next);
            }
            return true;
        }
        if (this.type == MonoType.OVERWRITE) {
            while (this.list.last != null && this.compartor.compare(this.list.last.item, e) > 0) {
                this.list.unlink(this.list.last);
            }
            this.list.linkLast(e);
            return true;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public E get(int index) {
        return this.list.get(index);
    }

    @Override
    public E remove(int index) {
        return this.list.remove(index);
    }

    @Override
    public boolean remove(Object o) {
        return this.list.remove(o);
    }

    @Override
    public int size() {
        return this.list.size;
    }

    @Override
    public String toString() {
        return "LinkedMonotoneList [type=" + (Object)((Object)this.type) + ", list=" + this.list + "]";
    }

    public static enum MonoType {
        INSERT,
        OVERWRITE;

    }
}

