/*
 * Decompiled with CFR 0.152.
 */
package xdean.jex.extra.collection;

import io.reactivex.Flowable;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.Iterator;
import java.util.function.Function;
import xdean.jex.extra.Either;
import xdean.jex.extra.rx2.RxIterator;

public class Traverse {
    private static <T> Deque<T> newDeque(T root) {
        ArrayDeque<T> deque = new ArrayDeque<T>();
        deque.add(root);
        return deque;
    }

    public static <T> Flowable<T> preOrderTraversal(T root, Function<T, Iterable<T>> getChildren) {
        return Flowable.generate(() -> Traverse.newDeque(Arrays.asList(root).iterator()), (d, e) -> {
            Iterator iterator;
            while (true) {
                if (d.isEmpty()) {
                    e.onComplete();
                    return;
                }
                iterator = (Iterator)d.peek();
                if (iterator.hasNext()) break;
                d.pop();
            }
            Object t = iterator.next();
            e.onNext(t);
            Iterator children = ((Iterable)getChildren.apply(t)).iterator();
            if (children.hasNext()) {
                d.push(children);
            }
        });
    }

    public static <T> Flowable<T> postOrderTraversal(T root, Function<T, Iterable<T>> getChildren) {
        return Flowable.generate(() -> Traverse.newDeque(Either.left(Arrays.asList(root).iterator())), (d, e) -> {
            Either item;
            do {
                if (d.isEmpty()) {
                    e.onComplete();
                    return;
                }
                item = (Either)d.peek();
                item.exec(iterator -> {
                    if (iterator.hasNext()) {
                        Object t = iterator.next();
                        Iterator children = ((Iterable)getChildren.apply(t)).iterator();
                        d.push(Either.right(t));
                        if (children.hasNext()) {
                            d.push(Either.left(children));
                        }
                    } else {
                        d.pop();
                    }
                }, value -> {
                    d.pop();
                    e.onNext(value);
                });
            } while (!item.isRight());
        });
    }

    public static <T> Flowable<T> breadthFirstTraversal(T root, Function<T, Iterable<T>> getChildren) {
        return Flowable.generate(() -> Traverse.newDeque(Arrays.asList(root).iterator()), (d, e) -> {
            Iterator iterator;
            while (true) {
                if (d.isEmpty()) {
                    e.onComplete();
                    return;
                }
                iterator = (Iterator)d.peek();
                if (iterator.hasNext()) break;
                d.pop();
            }
            Object t = iterator.next();
            e.onNext(t);
            Iterator children = ((Iterable)getChildren.apply(t)).iterator();
            if (children.hasNext()) {
                d.addLast(children);
            }
        });
    }

    public static enum DefaultTraverser implements Traverser
    {
        PRE_ORDER(Traverse::preOrderTraversal),
        POST_ORDER(Traverse::postOrderTraversal),
        BREAD_FIRST(Traverse::breadthFirstTraversal);

        private final Traverser traverser;

        private DefaultTraverser(Traverser traverser) {
            this.traverser = traverser;
        }

        @Override
        public <T> Flowable<T> travese(T root, Function<T, Iterable<T>> getChildren) {
            return this.traverser.travese(root, getChildren);
        }
    }

    @FunctionalInterface
    public static interface Traverser {
        public <T> Flowable<T> travese(T var1, Function<T, Iterable<T>> var2);
    }

    @FunctionalInterface
    public static interface Traversable<T>
    extends Iterable<T> {
        public Flowable<T> traverse(Traverser var1);

        default public Traverser defaultTraverser() {
            return DefaultTraverser.BREAD_FIRST;
        }

        @Override
        default public Iterator<T> iterator() {
            return this.iterator(this.defaultTraverser());
        }

        default public Iterator<T> iterator(Traverser traverser) {
            return (Iterator)this.traverse(traverser).to(RxIterator.flowableIterator());
        }

        default public Flowable<T> preOrderTraversal() {
            return this.traverse(DefaultTraverser.PRE_ORDER);
        }

        default public Flowable<T> postOrderTraversal() {
            return this.traverse(DefaultTraverser.POST_ORDER);
        }

        default public Flowable<T> breadthFirstTraversal() {
            return this.traverse(DefaultTraverser.BREAD_FIRST);
        }
    }
}

