/*
 * Decompiled with CFR 0.152.
 */
package xdean.jex.extra.json;

import com.google.common.base.Charsets;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import xdean.jex.extra.Either;
import xdean.jex.extra.Pair;
import xdean.jex.util.lang.ExceptionUtil;
import xdean.jex.util.lang.PrimitiveTypeUtil;
import xdean.jex.util.reflect.ReflectUtil;

public class JsonPrinter {
    private final List<Pair<Predicate<Object>, Function<Object, Object>>> objectHandlers = new LinkedList<Pair<Predicate<Object>, Function<Object, Object>>>();
    private final List<Predicate<Field>> fieldFilters = new LinkedList<Predicate<Field>>();
    private String tabCharacter = "  ";
    private boolean printClass = false;
    private PrintIdPolicy idPolicy = PrintIdPolicy.OFF;
    private boolean printStructedList = false;
    private boolean printStructedMap = false;
    private Function<Object, Integer> idFunction = System::identityHashCode;

    public static JsonPrinter getDefault() {
        return JsonPrinter.getJava().printIdPolicy(PrintIdPolicy.ONLY_REFERENCED).addObjectClassHandler(Either.class, e -> e.unify(a -> a, b -> b)).addObjectClassHandler(Multimap.class, m -> m.asMap()).addObjectClassHandler(Table.class, t -> t.rowMap());
    }

    public static JsonPrinter getJava() {
        return new JsonPrinter().addJavaHandlers().filterTransient().printClass(false).printStructedList(true).printStructedMap(true).idFunction(JsonPrinter.autoIncreaseId(0));
    }

    public static JsonPrinter getEmpty() {
        return new JsonPrinter();
    }

    public static Function<Object, Integer> autoIncreaseId(int from) {
        AtomicInteger id = new AtomicInteger(from);
        IdentityHashMap map = new IdentityHashMap();
        return o -> map.computeIfAbsent(o, e -> id.getAndIncrement());
    }

    public <T> JsonPrinter addObjectClassHandler(Class<T> clz, Function<T, Object> f) {
        return this.addObjectHandler(o -> clz.isInstance(o), o -> f.apply(o));
    }

    public JsonPrinter addObjectHandler(Predicate<Object> p, Function<Object, Object> f) {
        this.objectHandlers.add(Pair.of(p, f));
        return this;
    }

    public JsonPrinter addFieldFilter(Predicate<Field> p) {
        this.fieldFilters.add(p);
        return this;
    }

    public JsonPrinter tab(String t) {
        this.tabCharacter = t;
        return this;
    }

    public JsonPrinter printIdPolicy(PrintIdPolicy b) {
        this.idPolicy = b;
        return this;
    }

    public JsonPrinter printClass(boolean b) {
        this.printClass = b;
        return this;
    }

    public JsonPrinter printStructedList(boolean b) {
        this.printStructedList = b;
        return this;
    }

    public JsonPrinter printStructedMap(boolean b) {
        this.printStructedMap = b;
        return this;
    }

    public JsonPrinter idFunction(Function<Object, Integer> idFunction) {
        this.idFunction = idFunction;
        return this;
    }

    public JsonPrinter addJavaHandlers() {
        return this.addObjectClassHandler(Enum.class, e -> e.name()).addObjectClassHandler(Optional.class, o -> o.orElse(null)).addObjectClassHandler(OptionalInt.class, i -> i.isPresent() ? Integer.valueOf(i.getAsInt()) : null).addObjectClassHandler(OptionalDouble.class, i -> i.isPresent() ? Double.valueOf(i.getAsDouble()) : null).addObjectClassHandler(OptionalLong.class, i -> i.isPresent() ? Long.valueOf(i.getAsLong()) : null).addObjectClassHandler(Class.class, c -> c.getName()).addObjectClassHandler(Path.class, p -> p.toString().replace('\\', '/')).addObjectClassHandler(File.class, f -> f.toString().replace('\\', '/'));
    }

    public JsonPrinter filterTransient() {
        return this.addFieldFilter(f -> !Modifier.isTransient(f.getModifiers()));
    }

    public void print(Object o, PrintStream ps) {
        InnerPrinter innerPrinter = new InnerPrinter(ps);
        if (this.idPolicy == PrintIdPolicy.ONLY_REFERENCED) {
            innerPrinter.prepareReferenced(o);
        }
        innerPrinter.print(o);
    }

    public void println(Object o, PrintStream ps) {
        this.print(o, ps);
        ps.println();
    }

    public String toString(Object o, Charset cs) throws UnsupportedEncodingException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.print(o, new PrintStream((OutputStream)baos, false, cs.name()));
        return baos.toString(cs.name());
    }

    public String toString(Object o) {
        return ExceptionUtil.uncheck(() -> this.toString(o, Charsets.UTF_8));
    }

    private static String wrap(String string) {
        char c = '\u0000';
        int len = string.length();
        StringBuilder sb = new StringBuilder(len + 4);
        sb.append('\"');
        block8: for (int i = 0; i < len; ++i) {
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    sb.append('\\');
                    sb.append(c);
                    continue block8;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block8;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block8;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block8;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block8;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block8;
                }
                default: {
                    if (c < ' ') {
                        String t = "000" + Integer.toHexString(c);
                        sb.append("\\u" + t.substring(t.length() - 4));
                        continue block8;
                    }
                    sb.append(c);
                }
            }
        }
        sb.append('\"');
        return sb.toString();
    }

    private class InnerPrinter {
        int tab;
        Map<Object, Void> referenced = new IdentityHashMap<Object, Void>();
        Map<Object, Void> visited = new IdentityHashMap<Object, Void>();
        InnerPrintStream out;

        InnerPrinter(PrintStream ps) {
            this.out = new InnerPrintStream(ps);
        }

        private InnerPrinter prepareReferenced(Object o) {
            this.traversal(o, new IdentityHashMap<Object, Object>());
            return this;
        }

        private void traversal(Object o, Map<Object, Object> visited) {
            block12: {
                if (o == null) {
                    return;
                }
                Class<?> clz = o.getClass();
                if (PrimitiveTypeUtil.isWrapper(clz) || clz == String.class) break block12;
                if (clz.isArray()) {
                    int length = Array.getLength(o);
                    for (int i2 = 0; i2 < length; ++i2) {
                        this.traversal(Array.get(o, i2), visited);
                    }
                } else if (JsonPrinter.this.printStructedMap && Map.class.isAssignableFrom(clz)) {
                    ((Map)o).forEach((k, v) -> {
                        this.traversal(k, visited);
                        this.traversal(v, visited);
                    });
                } else if (JsonPrinter.this.printStructedList && Collection.class.isAssignableFrom(clz)) {
                    ((Collection)o).forEach(i -> this.traversal(i, visited));
                } else {
                    Optional<Function> selector = JsonPrinter.this.objectHandlers.stream().filter(p -> ((Predicate)p.getLeft()).test(o)).map(Pair::getRight).findFirst();
                    if (selector.isPresent()) {
                        this.traversal(selector.get().apply(o), visited);
                    } else {
                        Field[] allFields;
                        if (visited.put(o, o) != null) {
                            this.referenced.put(o, null);
                            return;
                        }
                        for (Field f : allFields = ReflectUtil.getAllFields(o.getClass(), false)) {
                            if (!JsonPrinter.this.fieldFilters.stream().allMatch(p -> p.test(f))) continue;
                            f.setAccessible(true);
                            Object v2 = ExceptionUtil.uncheck(() -> f.get(o));
                            this.traversal(v2, visited);
                        }
                    }
                }
            }
        }

        void print(Object o) {
            if (o == null) {
                this.out.print(o);
                return;
            }
            Class<?> clz = o.getClass();
            if (PrimitiveTypeUtil.isWrapper(clz)) {
                this.out.printPrimitive(o);
            } else if (clz == String.class) {
                this.out.print(JsonPrinter.wrap((String)o));
            } else if (clz.isArray()) {
                int length = Array.getLength(o);
                ArrayList<Object> l = new ArrayList<Object>(length);
                for (int i = 0; i < length; ++i) {
                    l.add(Array.get(o, i));
                }
                this.printList(l);
            } else if (JsonPrinter.this.printStructedMap && Map.class.isAssignableFrom(clz)) {
                this.printMap((Map)o);
            } else if (JsonPrinter.this.printStructedList && Collection.class.isAssignableFrom(clz)) {
                this.printList((Collection)o);
            } else {
                Optional<Function> selector = JsonPrinter.this.objectHandlers.stream().filter(p -> ((Predicate)p.getLeft()).test(o)).map(Pair::getRight).findFirst();
                if (selector.isPresent()) {
                    this.print(selector.get().apply(o));
                } else if (JsonPrinter.this.idPolicy == PrintIdPolicy.ALL && this.visited.containsKey(o) || JsonPrinter.this.idPolicy == PrintIdPolicy.ONLY_REFERENCED && this.visited.containsKey(o) && this.referenced.containsKey(o)) {
                    this.print("@" + JsonPrinter.this.idFunction.apply(o));
                } else {
                    this.visited.put(o, null);
                    this.printObject(o);
                }
            }
        }

        void printList(Collection<?> l) {
            Iterator<?> i = l.iterator();
            if (i.hasNext()) {
                this.out.println(Character.valueOf('['));
                ++this.tab;
                while (true) {
                    this.out.printTab();
                    this.print(i.next());
                    if (!i.hasNext()) break;
                    this.out.println(Character.valueOf(','));
                }
                this.out.println();
                --this.tab;
                this.out.printTab();
                this.out.print(Character.valueOf(']'));
            } else {
                this.out.print("[]");
            }
        }

        <K, V> void printMap(Map<K, V> map) {
            Iterator<Map.Entry<K, V>> i = map.entrySet().iterator();
            if (i.hasNext()) {
                this.out.println(Character.valueOf('{'));
                ++this.tab;
                while (true) {
                    this.out.printTab();
                    Map.Entry<K, V> next = i.next();
                    this.print(next.getKey());
                    this.out.print(": ");
                    this.print(next.getValue());
                    if (!i.hasNext()) break;
                    this.out.println(Character.valueOf(','));
                }
                this.out.println();
                --this.tab;
                this.out.printTab();
                this.out.print(Character.valueOf('}'));
            } else {
                this.out.print("{}");
            }
        }

        void printObject(Object o) {
            Field[] allFields = ReflectUtil.getAllFields(o.getClass(), false);
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            if (JsonPrinter.this.idPolicy == PrintIdPolicy.ALL || JsonPrinter.this.idPolicy == PrintIdPolicy.ONLY_REFERENCED && this.referenced.containsKey(o)) {
                map.put("UID", "@" + JsonPrinter.this.idFunction.apply(o));
            }
            if (JsonPrinter.this.printClass) {
                map.put("class", o.getClass());
            }
            for (Field f : allFields) {
                if (!JsonPrinter.this.fieldFilters.stream().allMatch(p -> p.test(f))) continue;
                f.setAccessible(true);
                Object v = ExceptionUtil.uncheck(() -> f.get(o));
                map.put(f.getName(), v);
            }
            this.printMap(map);
        }

        class InnerPrintStream {
            private PrintStream ps;

            InnerPrintStream(PrintStream ps) {
                this.ps = ps;
            }

            void print(Object o) {
                this.ps.print(o);
            }

            void printPrimitive(Object o) {
                if (o instanceof Character) {
                    this.print(Character.getNumericValue(((Character)o).charValue()));
                } else {
                    this.print(o);
                }
            }

            void printTab() {
                for (int i = 0; i < InnerPrinter.this.tab; ++i) {
                    this.ps.print(JsonPrinter.this.tabCharacter);
                }
            }

            void println() {
                this.ps.println();
            }

            void println(Object o) {
                this.ps.println(o);
            }
        }
    }

    public static enum PrintIdPolicy {
        ALL,
        ONLY_REFERENCED,
        OFF;

    }
}

