/*
 * Decompiled with CFR 0.152.
 */
package xdean.jex.extra.rx2;

import io.reactivex.Scheduler;
import io.reactivex.schedulers.Schedulers;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.ThreadFactory;
import xdean.jex.util.lang.FinalizeSupport;
import xdean.jex.util.log.LogUtil;

public class RxSchedulers {
    public static Scheduler fixedSize(final int size) {
        return RxSchedulers.autoClose(Executors.newFixedThreadPool(size, new ThreadFactory(){
            int i = 0;

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName("FixedSizeScheduler(size=" + size + ")-" + ++this.i);
                t.setPriority(5);
                t.setDaemon(true);
                return t;
            }
        }));
    }

    public static Scheduler forkJoin(final int size) {
        return RxSchedulers.autoClose(new ForkJoinPool(size, new ForkJoinPool.ForkJoinWorkerThreadFactory(){
            int i = 0;

            @Override
            public ForkJoinWorkerThread newThread(ForkJoinPool pool) {
                class FJWT
                extends ForkJoinWorkerThread {
                    protected FJWT(ForkJoinPool pool) {
                        super(pool);
                    }
                }
                FJWT t = new FJWT(pool);
                t.setName("ForkJoinScheduler(parallelism=" + size + ")-" + ++this.i);
                t.setPriority(5);
                t.setDaemon(true);
                return t;
            }
        }, null, true));
    }

    public static Scheduler autoClose(ExecutorService pool) {
        Scheduler scheduler = Schedulers.from((Executor)pool);
        FinalizeSupport.finalize(scheduler, () -> {
            LogUtil.debug().log("Shutdown the scheduler from: " + pool);
            pool.shutdown();
        });
        return scheduler;
    }
}

