/*
 * Decompiled with CFR 0.152.
 */
package xdean.jex.extra.rx2.nullable.impl;

import io.reactivex.Flowable;
import io.reactivex.Observable;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import xdean.jex.extra.rx2.nullable.handler.NullHandler;
import xdean.jex.extra.rx2.nullable.impl.OFWithHandler;
import xdean.jex.extra.rx2.nullable.source.NullableObservableFlowable;
import xdean.jex.extra.rx2.nullable.source.ObservableFlowable;

public class NullableFuture<F>
implements NullableObservableFlowable<F> {
    private final Future<F> future;
    private final long timeout;
    private final TimeUnit unit;

    public NullableFuture(Future<F> future) {
        this.future = future;
        this.timeout = 0L;
        this.unit = null;
    }

    public NullableFuture(Future<F> future, long timeout, TimeUnit unit) {
        this.future = future;
        this.timeout = timeout;
        this.unit = unit;
    }

    @Override
    public <T> ObservableFlowable<T> handler(NullHandler<F, T> handler) {
        return new Converter().handler((NullHandler)handler);
    }

    public class Converter<T>
    extends OFWithHandler<F, T> {
        @Override
        public Observable<T> observable() {
            return (NullableFuture.this.unit == null ? Observable.fromFuture(this.get()) : Observable.fromFuture(this.get(), (long)NullableFuture.this.timeout, (TimeUnit)NullableFuture.this.unit)).filter(Optional::isPresent).map(Optional::get);
        }

        @Override
        public Flowable<T> flowable() {
            return (NullableFuture.this.unit == null ? Flowable.fromFuture(this.get()) : Flowable.fromFuture(this.get(), (long)NullableFuture.this.timeout, (TimeUnit)NullableFuture.this.unit)).filter(Optional::isPresent).map(Optional::get);
        }

        private Future<Optional<T>> get() {
            return new Future<Optional<T>>(){

                @Override
                public boolean cancel(boolean mayInterruptIfRunning) {
                    return NullableFuture.this.future.cancel(mayInterruptIfRunning);
                }

                @Override
                public boolean isCancelled() {
                    return NullableFuture.this.future.isCancelled();
                }

                @Override
                public boolean isDone() {
                    return NullableFuture.this.future.isDone();
                }

                @Override
                public Optional<T> get() throws InterruptedException, ExecutionException {
                    return this.convert(NullableFuture.this.future.get());
                }

                @Override
                public Optional<T> get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                    return this.convert(NullableFuture.this.future.get(timeout, unit));
                }

                private Optional<T> convert(F f) {
                    return Optional.ofNullable(Converter.this.handler.apply(f));
                }
            };
        }
    }
}

