/*
 * Decompiled with CFR 0.152.
 */
package xdean.jex.extra.rx2.op;

import io.reactivex.FlowableOperator;
import io.reactivex.FlowableSubscriber;
import io.reactivex.ObservableOperator;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class RandomOperator<T> {
    private static final int DEFAULT_CACHE = 128;

    public static <T> ObservableOperator<T, T> observable() {
        return RandomOperator.observable(128);
    }

    public static <T> ObservableOperator<T, T> observable(int cacheSize) {
        return actual -> new RandomObserver(actual, cacheSize);
    }

    public static <T> FlowableOperator<T, T> flowable() {
        return RandomOperator.flowable(128);
    }

    public static <T> FlowableOperator<T, T> flowable(int cacheSize) {
        return actual -> new RandomSubscriber(actual, cacheSize);
    }

    private static final class RandomSubscriber<T>
    extends AtomicLong
    implements FlowableSubscriber<T>,
    Subscription {
        int cacheSize;
        List<T> elements;
        Subscriber<? super T> actual;
        Subscription s;

        public RandomSubscriber(Subscriber<? super T> actual, int cacheSize) {
            this.elements = new ArrayList<T>(cacheSize);
            this.cacheSize = cacheSize;
            this.actual = actual;
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate((Subscription)this.s, (Subscription)s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            this.elements.add(t);
            if (this.elements.size() == this.cacheSize) {
                this.emitOne();
            }
            if (this.get() > 0L) {
                this.s.request(1L);
            }
        }

        public void onError(Throwable e) {
            this.actual.onError(e);
        }

        public void onComplete() {
            this.emitAll();
            this.actual.onComplete();
        }

        public void request(long n) {
            if (BackpressureHelper.add((AtomicLong)this, (long)n) == 0L) {
                this.s.request(n);
            }
        }

        public void cancel() {
            this.s.cancel();
        }

        private void emitOne() {
            this.actual.onNext(this.elements.remove((int)(Math.random() * (double)this.elements.size())));
            BackpressureHelper.produced((AtomicLong)this, (long)1L);
        }

        private void emitAll() {
            while (!this.elements.isEmpty() && this.get() > 0L) {
                this.emitOne();
            }
        }
    }

    private static final class RandomObserver<T>
    implements Observer<T> {
        int cacheSize;
        List<T> elements;
        Observer<? super T> actual;

        public RandomObserver(Observer<? super T> actual, int cacheSize) {
            this.actual = actual;
            this.cacheSize = cacheSize;
            this.elements = new ArrayList<T>(cacheSize);
        }

        public void onSubscribe(Disposable d) {
            this.actual.onSubscribe(d);
        }

        public void onNext(T t) {
            if (this.elements.size() == this.cacheSize) {
                this.emitOne();
            }
            this.elements.add(t);
        }

        public void onError(Throwable e) {
            this.actual.onError(e);
        }

        public void onComplete() {
            this.emitAll();
            this.actual.onComplete();
        }

        private void emitOne() {
            this.actual.onNext(this.elements.remove((int)(Math.random() * (double)this.elements.size())));
        }

        private void emitAll() {
            while (!this.elements.isEmpty()) {
                this.emitOne();
            }
        }
    }
}

