/*
 * Decompiled with CFR 0.152.
 */
package xdean.jex.internal.codecov;

import com.google.common.base.Charsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import xdean.jex.internal.codecov.CodecovIgnore;
import xdean.jex.util.file.FileUtil;
import xdean.jex.util.lang.ExceptionUtil;
import xdean.jex.util.log.LogUtil;

@CodecovIgnore
public class CodecovIgnoreHandler {
    private static final String END = "#end";
    private static final String IGNORE = "ignore:";
    private static final String GENERATED = "#generated";

    public static void main(String[] args) {
        CodecovIgnoreHandler.updateCodecovIgnore();
    }

    public static void updateCodecovIgnore() {
        Path codecov = Paths.get("codecov.yml", new String[0]);
        if (!Files.exists(codecov, new LinkOption[0])) {
            LogUtil.error().log("Can't find codecov.yml");
            return;
        }
        Path path = Paths.get("src", "main", "java");
        CodecovIgnoreHandler.updateCodecovIgnore(codecov, path);
    }

    public static void updateCodecovIgnore(Path codecov, Path sourcePath) {
        FileUtil.deepTraversal(sourcePath).filter(p -> !Files.isDirectory(p, new LinkOption[0])).filter(p -> p.getFileName().toString().endsWith(".java")).filter(p -> {
            String name = StreamSupport.stream(p.spliterator(), false).skip(3L).map(Path::toString).collect(Collectors.joining("."));
            String clzName = name.substring(0, name.length() - 5);
            return ExceptionUtil.uncatch(() -> Class.forName(clzName).getAnnotation(CodecovIgnore.class)) != null;
        }).doOnNext(p -> LogUtil.debug().log("Find file to ignore: " + p)).toList().subscribe(ignores -> CodecovIgnoreHandler.writeIgnore(codecov, ignores));
    }

    private static void writeIgnore(Path codecov, List<Path> ignores) {
        List lines = ExceptionUtil.uncheck(() -> Files.readAllLines(codecov, Charsets.UTF_8));
        List ignoreLines = ignores.stream().map(p -> p.toString().replace('\\', '/')).map(s -> "  - \"" + s + "\"").collect(Collectors.toList());
        ignoreLines.add(0, GENERATED);
        ignoreLines.add(END);
        int ignoreLine = lines.indexOf(IGNORE);
        int generateLine = lines.indexOf(GENERATED);
        int endLine = lines.indexOf(END);
        if (ignoreLine == -1) {
            lines.add(IGNORE);
            lines.addAll(ignoreLines);
        } else {
            if (generateLine == -1 ^ endLine == -1) {
                LogUtil.error().log("'#generated' and '#end' tags are not synchronized, correct the file manually.");
                return;
            }
            if (generateLine == -1) {
                lines.addAll(ignoreLine + 1, ignoreLines);
            } else {
                for (int i = generateLine; i <= endLine; ++i) {
                    lines.remove(generateLine);
                }
                lines.addAll(generateLine, ignoreLines);
            }
        }
        ExceptionUtil.uncheck(() -> Files.write(codecov, (Iterable<? extends CharSequence>)lines, new OpenOption[0]));
        LogUtil.info().log("codecov.yml has been updated!");
    }
}

