/*
 * Decompiled with CFR 0.152.
 */
package xdean.jex.util.lang;

import java.lang.reflect.Array;
import xdean.jex.util.lang.PrimitiveTypeUtil;

public class ArrayUtil {
    public static Object deepClone(Object array) {
        if (array == null || !array.getClass().isArray()) {
            return array;
        }
        int len = Array.getLength(array);
        Object newArray = Array.newInstance(array.getClass().getComponentType(), len);
        for (int i = 0; i < len; ++i) {
            Array.set(newArray, i, ArrayUtil.deepClone(Array.get(array, i)));
        }
        return newArray;
    }

    public static int[][] transpose(int[][] origin) {
        return (int[][])PrimitiveTypeUtil.toPrimitiveArray(ArrayUtil.transpose((Integer[][])PrimitiveTypeUtil.toWrapperArray(origin)));
    }

    public static long[][] transpose(long[][] origin) {
        return (long[][])PrimitiveTypeUtil.toPrimitiveArray(ArrayUtil.transpose((Long[][])PrimitiveTypeUtil.toWrapperArray(origin)));
    }

    public static <T> T[][] transpose(T[][] origin) {
        Class<?> clz = origin.getClass();
        Object[][] ret = (Object[][])Array.newInstance(clz.getComponentType(), origin[0].length);
        int created = 0;
        int len = 0;
        for (int i = origin.length - 1; i >= 0; --i) {
            int m;
            if (origin[i].length < len) {
                throw new IllegalArgumentException();
            }
            len = origin[i].length;
            for (m = created; m < len; ++m) {
                ret[m] = (Object[])Array.newInstance(clz.getComponentType().getComponentType(), i + 1);
            }
            created = len;
            for (m = 0; m < origin[i].length; ++m) {
                ret[m][i] = origin[i][m];
            }
        }
        return ret;
    }

    public static int compare(int[] a, int[] b) {
        if (a.length != b.length) {
            throw new IllegalArgumentException("Can't compare different length arrays");
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return a[i] - b[i];
        }
        return 0;
    }

    public static <T extends Comparable<T>> int compare(T[] a, T[] b) {
        if (a.length != b.length) {
            throw new IllegalArgumentException("Can't compare different length arrays");
        }
        for (int i = 0; i < a.length; ++i) {
            int compare = a[i].compareTo(b[i]);
            if (compare == 0) continue;
            return compare;
        }
        return 0;
    }
}

