/*
 * Decompiled with CFR 0.152.
 */
package xdean.jex.util.log;

import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import xdean.jex.internal.codecov.CodecovIgnore;
import xdean.jex.util.log.Log;
import xdean.jex.util.reflect.ReflectUtil;

@CodecovIgnore
public class LogUtil {
    public static void setGlobalLevel(Level newLevel) {
        Logger rootLogger = LogManager.getLogManager().getLogger("");
        rootLogger.setLevel(newLevel);
        for (Handler h : rootLogger.getHandlers()) {
            h.setLevel(newLevel);
        }
    }

    public static Logger logger() {
        return Logger.getLogger(ReflectUtil.getCallerClassName());
    }

    public static Logger logger(Class<?> clz) {
        return Logger.getLogger(clz.getName());
    }

    public static Logger logger(Object o) {
        return LogUtil.logger(o.getClass());
    }

    public static Log log() {
        return Log.of(Logger.getLogger(ReflectUtil.getCallerClassName()));
    }

    public static Log log(Class<?> clz) {
        return Log.of(Logger.getLogger(clz.getName()));
    }

    public static Log log(Object o) {
        return LogUtil.log(o.getClass());
    }

    public static Log.SubLog trace() {
        return Log.of(Logger.getLogger(ReflectUtil.getCallerClassName())).trace();
    }

    public static Log.SubLog trace(Class<?> clz) {
        return Log.of(Logger.getLogger(clz.getName())).trace();
    }

    public static Log.SubLog trace(Object o) {
        return LogUtil.log(o.getClass()).trace();
    }

    public static Log.SubLog debug() {
        return Log.of(Logger.getLogger(ReflectUtil.getCallerClassName())).debug();
    }

    public static Log.SubLog debug(Class<?> clz) {
        return Log.of(Logger.getLogger(clz.getName())).debug();
    }

    public static Log.SubLog debug(Object o) {
        return LogUtil.log(o.getClass()).debug();
    }

    public static Log.SubLog info() {
        return Log.of(Logger.getLogger(ReflectUtil.getCallerClassName())).info();
    }

    public static Log.SubLog info(Class<?> clz) {
        return Log.of(Logger.getLogger(clz.getName())).info();
    }

    public static Log.SubLog info(Object o) {
        return LogUtil.log(o.getClass()).info();
    }

    public static Log.SubLog warning() {
        return Log.of(Logger.getLogger(ReflectUtil.getCallerClassName())).warning();
    }

    public static Log.SubLog warning(Class<?> clz) {
        return Log.of(Logger.getLogger(clz.getName())).warning();
    }

    public static Log.SubLog warning(Object o) {
        return LogUtil.log(o.getClass()).warning();
    }

    public static Log.SubLog error() {
        return Log.of(Logger.getLogger(ReflectUtil.getCallerClassName())).error();
    }

    public static Log.SubLog error(Class<?> clz) {
        return Log.of(Logger.getLogger(clz.getName())).error();
    }

    public static Log.SubLog error(Object o) {
        return LogUtil.log(o.getClass()).error();
    }

    static {
        String property = System.getProperty("xdean.jex.log.level");
        property = property == null ? "" : property;
        switch (property.toLowerCase()) {
            case "trace": {
                LogUtil.setGlobalLevel(Level.FINEST);
                break;
            }
            case "debug": {
                LogUtil.setGlobalLevel(Level.FINER);
                break;
            }
            case "info": {
                LogUtil.setGlobalLevel(Level.INFO);
                break;
            }
            case "warning": {
                LogUtil.setGlobalLevel(Level.WARNING);
                break;
            }
            case "error": {
                LogUtil.setGlobalLevel(Level.SEVERE);
                break;
            }
            default: {
                LogUtil.setGlobalLevel(Level.INFO);
            }
        }
    }
}

