/*
 * Decompiled with CFR 0.152.
 */
package xdean.jex.util.reflect;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import xdean.jex.util.lang.PrimitiveTypeUtil;
import xdean.jex.util.log.Log;
import xdean.jex.util.log.LogUtil;
import xdean.jex.util.reflect.GenericUtil;

public class FunctionInterfaceUtil {
    private static final Log LOG = LogUtil.log();

    public static <T> Method getFunctionInterfaceMethod(Class<?> clz) {
        if (!clz.isInterface()) {
            return null;
        }
        Method[] ms = (Method[])Stream.of(clz.getMethods()).filter(m -> !m.isDefault() && !m.isBridge() && !m.isSynthetic() && !Modifier.isStatic(m.getModifiers())).toArray(Method[]::new);
        if (ms.length != 1) {
            return null;
        }
        return ms[0];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T> T methodToFunctionInterface(Method method, Object target, Class<T> functionInterfaceClass, Class<?> ... explicitGenericTypes) {
        Method functionMethod = FunctionInterfaceUtil.getFunctionInterfaceMethod(functionInterfaceClass);
        if (functionMethod == null) {
            return null;
        }
        if (functionMethod.getParameterCount() != method.getParameterCount()) {
            return null;
        }
        HashMap explicitTypeMap = new HashMap();
        TypeVariable<Class<T>>[] typeParameters = functionInterfaceClass.getTypeParameters();
        if (explicitGenericTypes.length > typeParameters.length) {
            throw new IllegalArgumentException("The explicit generic types are too many. Expect " + typeParameters.length);
        }
        for (int i = 0; i < explicitGenericTypes.length; ++i) {
            explicitTypeMap.put(typeParameters[i], PrimitiveTypeUtil.toWrapper(explicitGenericTypes[i]));
        }
        Map<TypeVariable<?>, Type> typeVariableReference = GenericUtil.getGenericReferenceMap(functionInterfaceClass);
        Function<TypeVariable, Class> getActualTypeVariable = tv -> {
            Type next;
            while ((next = (Type)typeVariableReference.get(tv)) != null) {
                if (next instanceof Class) {
                    return (Class)next;
                }
                tv = (TypeVariable)next;
            }
            return (Class)explicitTypeMap.get(tv);
        };
        Class<?> returnType = PrimitiveTypeUtil.toWrapper(method.getReturnType());
        Type functionGenericReturnType = functionMethod.getGenericReturnType();
        if (functionGenericReturnType instanceof ParameterizedType) {
            functionGenericReturnType = ((ParameterizedType)functionGenericReturnType).getRawType();
        }
        if (returnType != Void.TYPE || functionGenericReturnType != Void.TYPE) {
            if (functionGenericReturnType instanceof Class) {
                if (!PrimitiveTypeUtil.toWrapper((Class)functionGenericReturnType).isAssignableFrom(returnType)) {
                    return null;
                }
            } else if (functionGenericReturnType instanceof TypeVariable) {
                TypeVariable tv2 = (TypeVariable)functionGenericReturnType;
                Class explicitType = getActualTypeVariable.apply(tv2);
                if (explicitType != null) {
                    if (!explicitType.equals(returnType)) {
                        return null;
                    }
                } else {
                    if (!FunctionInterfaceUtil.matchTypeBounds(returnType, tv2)) return null;
                    explicitTypeMap.put(tv2, returnType);
                }
            } else {
                LOG.warning().log("Can't handle GenericReturnType: {} with type {}", functionGenericReturnType, functionGenericReturnType.getClass());
                return null;
            }
        }
        Type[] functionParams = functionMethod.getGenericParameterTypes();
        Class<?>[] params = method.getParameterTypes();
        for (int i = 0; i < params.length; ++i) {
            Type functionParamType = functionParams[i];
            Class<?> paramType = PrimitiveTypeUtil.toWrapper(params[i]);
            if (functionParamType instanceof ParameterizedType) {
                functionParamType = ((ParameterizedType)functionParamType).getRawType();
            }
            if (functionParamType instanceof Class) {
                if (paramType.isAssignableFrom(PrimitiveTypeUtil.toWrapper((Class)functionParamType))) continue;
                return null;
            }
            if (functionParamType instanceof TypeVariable) {
                TypeVariable tv3 = (TypeVariable)functionParamType;
                Class explicitType = getActualTypeVariable.apply(tv3);
                if (explicitType != null) {
                    if (explicitType.equals(paramType)) continue;
                    return null;
                }
                if (!FunctionInterfaceUtil.matchTypeBounds(paramType, tv3)) return null;
                explicitTypeMap.put(tv3, paramType);
                continue;
            }
            LOG.warning().log("Can't handle GenericParameterType: {} with type {}", paramType, paramType.getClass());
            return null;
        }
        List<Type> functionExceptionTypes = Arrays.asList(functionMethod.getGenericExceptionTypes());
        for (Class<?> exceptionType : method.getExceptionTypes()) {
            if (!Exception.class.isAssignableFrom(exceptionType) || RuntimeException.class.isAssignableFrom(exceptionType) || functionExceptionTypes.stream().anyMatch(functionThrowType -> {
                Class functionThrowClass = null;
                if (functionThrowType instanceof Class) {
                    functionThrowClass = (Class)functionThrowType;
                } else if (functionThrowType instanceof TypeVariable) {
                    Class explicitType = (Class)explicitTypeMap.get(functionThrowType);
                    if (explicitType == null) {
                        return FunctionInterfaceUtil.matchTypeBounds(exceptionType, (TypeVariable)functionThrowType);
                    }
                    functionThrowClass = explicitType;
                } else {
                    LOG.warning().log("Can't handle GenericException: {} with type {}", functionThrowType, functionThrowType.getClass());
                    return false;
                }
                return functionThrowClass.isAssignableFrom(exceptionType);
            })) continue;
            return null;
        }
        return (T)Proxy.newProxyInstance(functionInterfaceClass.getClassLoader(), new Class[]{functionInterfaceClass}, (obj, m, args) -> {
            if (m.equals(functionMethod)) {
                return method.invoke(target, args);
            }
            Class<?> declaringClass = m.getDeclaringClass();
            if (m.isDefault() || declaringClass.equals(Object.class)) {
                Constructor constructor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class, Integer.TYPE);
                constructor.setAccessible(true);
                Object result = ((MethodHandles.Lookup)constructor.newInstance(declaringClass, 2)).unreflectSpecial(m, declaringClass).bindTo(obj).invokeWithArguments(args);
                return result;
            }
            return m.invoke(obj, args);
        });
    }

    private static boolean matchTypeBounds(Class<?> clz, TypeVariable<?> tv) {
        Class<?> wrapClz = PrimitiveTypeUtil.toWrapper(clz);
        return FunctionInterfaceUtil.getAllBounds(tv).allMatch(c -> PrimitiveTypeUtil.toWrapper(c).isAssignableFrom(wrapClz));
    }

    private static Stream<Class<?>> getAllBounds(TypeVariable<?> tv) {
        return Stream.of(tv.getBounds()).flatMap(t -> {
            if (t instanceof Class) {
                return Stream.of((Class)t);
            }
            if (t instanceof TypeVariable) {
                return FunctionInterfaceUtil.getAllBounds((TypeVariable)t);
            }
            LOG.warning().log("Can't handle TypeVariable Bound: {} with type {}", t, t.getClass());
            return Stream.empty();
        });
    }
}

