/*
 * Decompiled with CFR 0.152.
 */
package xdean.jex.util.reflect;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import xdean.jex.util.function.Predicates;
import xdean.jex.util.reflect.TypeVisitor;
import xdean.jex.util.reflect.model.GenericArrayTypeImpl;
import xdean.jex.util.reflect.model.ParameterizedTypeImpl;
import xdean.jex.util.reflect.model.WildcardTypeImpl;

public class GenericUtil {
    private static final Type[] EMPTY_TYPE_ARRAY = new Type[0];

    public static ParameterizedType createParameterizedType(Class<?> rawType, Type ownerType, Type ... actualTypeArguments) {
        return new ParameterizedTypeImpl(rawType, ownerType, actualTypeArguments);
    }

    public static WildcardType createWildcardType(Type[] upperBounds, Type[] lowerBounds) {
        return new WildcardTypeImpl(GenericUtil.nullToEmpty(lowerBounds), GenericUtil.nullToEmpty(upperBounds));
    }

    public static GenericArrayType createGenericArrayType(Type componentType) {
        return new GenericArrayTypeImpl(componentType);
    }

    public static Map<TypeVariable<?>, Type> getGenericReferenceMap(Type type) {
        return TypeVisitor.of(type, b -> b.onClass(GenericUtil::getGenericReferenceMap).onParameterizedType(GenericUtil::getGenericReferenceMap).result(Collections::emptyMap));
    }

    public static Map<TypeVariable<?>, Type> getGenericReferenceMap(ParameterizedType parameterizedType) {
        return TypeVisitor.of(parameterizedType.getRawType(), b -> b.onClass(c -> {
            HashMap map = new HashMap();
            map.putAll(GenericUtil.getGenericReferenceMap(c));
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            TypeVariable<Class<T>>[] implTypeParams = c.getTypeParameters();
            for (int i = 0; i < actualTypeArguments.length; ++i) {
                map.put(implTypeParams[i], actualTypeArguments[i]);
            }
            return map;
        }).result(Collections::emptyMap));
    }

    public static Map<TypeVariable<?>, Type> getGenericReferenceMap(Class<?> clz) {
        HashMap map = new HashMap();
        ArrayList<Type> allTypes = new ArrayList<Type>();
        allTypes.add(clz.getGenericSuperclass());
        allTypes.addAll(Arrays.asList(clz.getGenericInterfaces()));
        allTypes.stream().filter(Predicates.not(null)).map(GenericUtil::getGenericReferenceMap).forEach(map::putAll);
        return map;
    }

    public static Type[] getGenericTypes(Type sourceType, Class<?> targetClass) {
        TypeVariable<Class<?>>[] targetTypeParameters = targetClass.getTypeParameters();
        if (targetTypeParameters.length == 0) {
            return EMPTY_TYPE_ARRAY;
        }
        Map<TypeVariable<?>, Type> map = GenericUtil.getGenericReferenceMap(sourceType);
        List leftTypeParameters = sourceType instanceof Class ? Arrays.asList(((Class)sourceType).getTypeParameters()) : Collections.emptyList();
        return (Type[])Arrays.stream(targetTypeParameters).map(tv -> {
            Type actualType = GenericUtil.getActualType(map, tv);
            return Objects.equals(actualType, tv) && !leftTypeParameters.contains(actualType) ? null : actualType;
        }).toArray(Type[]::new);
    }

    private static Type getActualType(Map<TypeVariable<?>, Type> map, Type type) {
        return TypeVisitor.of(type, b -> b.onClass(c -> c).onTypeVariable(tv -> map.containsKey(tv) ? GenericUtil.getActualType(map, (Type)map.get(tv)) : tv).onParameterizedType(pt -> TypeVisitor.of(pt.getRawType(), bb -> bb.onClass(c -> GenericUtil.createParameterizedType(c, pt.getOwnerType(), (Type[])Arrays.stream(pt.getActualTypeArguments()).map(t -> GenericUtil.getActualType(map, t)).toArray(Type[]::new))).result())).onWildcardType(wt -> GenericUtil.createWildcardType((Type[])Arrays.stream(wt.getUpperBounds()).map(t -> GenericUtil.getActualType(map, t)).toArray(Type[]::new), (Type[])Arrays.stream(wt.getLowerBounds()).map(t -> GenericUtil.getActualType(map, t)).toArray(Type[]::new))).onGenericArrayType(gat -> GenericUtil.createGenericArrayType(GenericUtil.getActualType(map, gat.getGenericComponentType()))).result(type));
    }

    private static Type[] nullToEmpty(Type[] upperBounds) {
        return upperBounds == null ? EMPTY_TYPE_ARRAY : upperBounds;
    }
}

