/*
 * Decompiled with CFR 0.152.
 */
package xdean.jex.util.string;

import com.google.common.collect.Ordering;
import java.util.Base64;
import java.util.Comparator;
import java.util.Iterator;
import java.util.stream.Stream;
import xdean.jex.extra.collection.IntList;
import xdean.jex.util.cache.CacheUtil;

public class StringUtil {
    public static String replaceExcept(String origin, String from, String to, String except) {
        if (except.contains(from)) {
            String holder = StringUtil.notExistChars(origin).next().toString();
            return origin.replace(except, holder).replace(from, to).replace(holder, except);
        }
        return origin.replace(from, to);
    }

    public static Iterator<Character> notExistChars(final String s) {
        return new Iterator<Character>(){
            IntList collect;
            int current;
            Character next;
            {
                this.collect = IntList.create(s.chars().distinct().sorted().toArray());
                this.current = 128;
                this.next = null;
            }

            @Override
            public Character next() {
                if (this.calcNext()) {
                    Character c = this.next;
                    this.next = null;
                    return c;
                }
                throw new IllegalStateException("No next not exist char.");
            }

            @Override
            public boolean hasNext() {
                return this.calcNext();
            }

            private boolean calcNext() {
                if (this.next == null) {
                    while (++this.current < Integer.MAX_VALUE) {
                        if (this.collect.remove(this.current)) continue;
                        this.next = Character.valueOf((char)this.current);
                        return true;
                    }
                    return false;
                }
                return true;
            }
        };
    }

    public static String repeat(String st, int times) {
        StringBuilder sb = new StringBuilder();
        while (times-- > 0) {
            sb.append(st);
        }
        return sb.toString();
    }

    public static int firstIndexOf(String str, String ... ts) {
        return Stream.of(ts).map(str::indexOf).filter(i -> i != -1).min((Comparator<Integer>)Ordering.natural()).orElse(-1);
    }

    public static int lastIndexOf(String str, String ... ts) {
        return Stream.of(ts).map(str::lastIndexOf).filter(i -> i != -1).max((Comparator<Integer>)Ordering.natural()).orElse(-1);
    }

    public static String replacePart(String sourceText, int from, int to, String replaceText) {
        if (from > to || from < 0 || to > sourceText.length()) {
            throw new StringIndexOutOfBoundsException();
        }
        return String.format("%s%s%s", sourceText.substring(0, from), replaceText, sourceText.substring(to));
    }

    public static String unWrap(String str, String left, String right) {
        String trim = str.trim();
        if (trim.length() < left.length() + right.length()) {
            return str;
        }
        if (trim.startsWith(left) && trim.endsWith(right)) {
            return trim.substring(left.length(), trim.length() - right.length());
        }
        return str;
    }

    public static int[] balancePair(String str, String left, String right) {
        int rightIndex;
        int count = 0;
        int offset = 0;
        int firstLeft = -1;
        while (true) {
            int leftIndex;
            if ((leftIndex = str.indexOf(left, offset)) == (rightIndex = str.indexOf(right, offset))) {
                return new int[]{firstLeft, -1};
            }
            if (leftIndex < rightIndex && leftIndex != -1 || rightIndex == -1) {
                if (firstLeft == -1) {
                    firstLeft = leftIndex;
                }
                ++count;
                offset = leftIndex + 1;
                continue;
            }
            offset = rightIndex + 1;
            if (--count < 0) {
                return new int[]{firstLeft, -1};
            }
            if (count == 0) break;
        }
        return new int[]{firstLeft, rightIndex};
    }

    public static boolean isControlCharacter(char c) {
        return c < ' ' || c == '\u007f';
    }

    public static int countLine(String str) {
        return str.split("\\R").length;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.equals("");
    }

    public static boolean notEmpty(String str) {
        return !StringUtil.isEmpty(str);
    }

    public static String upperFirst(String st) {
        return st.substring(0, 1).toUpperCase() + st.substring(1).toLowerCase();
    }

    public static int indexOfIgnoreCase(String str, String target) {
        return StringUtil.indexOfIgnoreCase(str, target, 0);
    }

    public static int indexOfIgnoreCase(String str, String target, int startIndex) {
        return CacheUtil.cache(str, "lowerCase", () -> str.toLowerCase()).indexOf(CacheUtil.cache(target, "lowerCase", () -> target.toLowerCase()), startIndex);
    }

    public static String encode(String str) {
        return new String(Base64.getEncoder().encode(str.getBytes()));
    }

    public static String decode(String str) {
        return new String(Base64.getDecoder().decode(str.getBytes()));
    }

    public static String camelToUnderline(String param) {
        if (param == null || "".equals(param.trim())) {
            return "";
        }
        int len = param.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = param.charAt(i);
            if (Character.isUpperCase(c) || Character.isDigit(c)) {
                sb.append("_");
                sb.append(c);
                continue;
            }
            sb.append(Character.toUpperCase(c));
        }
        return sb.toString();
    }
}

