/*
 * Decompiled with CFR 0.152.
 */
package xdean.jex.util.task.tryto;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import xdean.jex.util.task.tryto.Success;
import xdean.jex.util.task.tryto.Try;

public class Failure<T>
extends Try<T> {
    private final Exception exception;

    Failure(Exception e) {
        this.exception = e;
    }

    @Override
    public boolean isFailure() {
        return true;
    }

    @Override
    public boolean isSuccess() {
        return false;
    }

    @Override
    public T get() {
        throw new RuntimeException(this.exception.getMessage(), this.exception);
    }

    @Override
    public Try<T> foreach(Consumer<T> f) {
        return this;
    }

    @Override
    public <U> Try<U> flatMap(Function<T, Try<U>> f) {
        return this;
    }

    @Override
    public <U> Try<U> map(Function<T, U> f) {
        return this;
    }

    @Override
    public Try<T> filter(Predicate<T> p) {
        return this;
    }

    @Override
    public Try<T> recoverWith(Function<Exception, Try<T>> f) {
        try {
            return f.apply(this.exception);
        }
        catch (Exception e) {
            return new Failure<T>(e);
        }
    }

    @Override
    public Try<T> recover(Function<Exception, T> f) {
        try {
            return Try.to(() -> f.apply(this.exception));
        }
        catch (RuntimeException e) {
            return new Failure<T>(e);
        }
    }

    @Override
    public Try<Exception> failed() {
        return new Success<Exception>(this.exception);
    }

    @Override
    public <U> Try<U> transform(Function<T, Try<U>> s, Function<Exception, Try<U>> f) {
        try {
            return f.apply(this.exception);
        }
        catch (RuntimeException e) {
            return new Failure<T>(e);
        }
    }

    @Override
    public Try<T> onException(Consumer<Exception> f) {
        f.accept(this.exception);
        return this;
    }
}

