/*
 * Decompiled with CFR 0.152.
 */
package xdean.reflect.getter;

import java.lang.reflect.Method;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import xdean.jex.extra.function.SupplierThrow;
import xdean.jex.util.task.TaskUtil;
import xdean.jex.util.task.tryto.Try;
import xdean.reflect.getter.InvokeGetter;
import xdean.reflect.getter.PropertyGetter;

public interface MethodGetter<T>
extends InvokeGetter<T, Method>,
PropertyGetter<T> {
    public static final int UP_LOW_GAP = 32;

    @Override
    default public Method get(BiConsumer<T, ?> setter) {
        return (Method)this.get(Helper.setterToFunction(setter));
    }

    @Override
    default public String getName(Function<T, ?> invoke) {
        String name = ((Method)this.get(invoke)).getName();
        return (String)Optional.ofNullable(TaskUtil.firstSuccess((SupplierThrow[])new SupplierThrow[]{() -> Helper.getterToName(name), () -> Helper.setterToName(name)})).orElseThrow(() -> new IllegalArgumentException("Can't get property name from method name: " + name));
    }

    @Override
    default public String getName(BiConsumer<T, ?> setter) {
        return this.getName(Helper.setterToFunction(setter));
    }

    @Override
    default public Class<?> getType(Function<T, ?> invoke) {
        return ((Method)this.get(invoke)).getReturnType();
    }

    @Override
    default public Class<?> getType(BiConsumer<T, ?> setter) {
        return this.getType(Helper.setterToFunction(setter));
    }

    @Override
    default public String nameOf(BiConsumer<T, ?> setter) {
        return this.nameOf(Helper.setterToFunction(setter));
    }

    @Override
    default public Class<?> typeOf(BiConsumer<T, ?> setter) {
        return this.typeOf(Helper.setterToFunction(setter));
    }

    public static class Helper {
        private static String getterToName(String getterName) {
            if (getterName.startsWith("get") && getterName.length() > 3) {
                return (char)(getterName.charAt(3) + 32) + getterName.substring(4);
            }
            if (getterName.startsWith("is") && getterName.length() > 2) {
                return (char)(getterName.charAt(2) + 32) + getterName.substring(3);
            }
            throw new IllegalArgumentException("Getter method name must be (get|is)XxxXxx, but was \"" + getterName + "\".");
        }

        private static String setterToName(String setterName) {
            if (setterName.startsWith("set") && setterName.length() > 3) {
                return (char)(setterName.charAt(3) + 32) + setterName.substring(4);
            }
            throw new IllegalArgumentException("Setter method name must be (get|is)XxxXxx, but was \"" + setterName + "\".");
        }

        private static <T, V> Function<T, ?> setterToFunction(BiConsumer<T, V> setter) {
            return c -> {
                Try.to(() -> setter.accept(c, null)).recover(Helper.adapt(e -> setter.accept(c, 0))).recover(Helper.adapt(e -> setter.accept(c, 0.0))).recover(Helper.adapt(e -> setter.accept(c, false))).recover(Helper.adapt(e -> setter.accept(c, Float.valueOf(0.0f)))).recover(Helper.adapt(e -> setter.accept(c, 0L))).recover(Helper.adapt(e -> setter.accept(c, Character.valueOf('0')))).recover(Helper.adapt(e -> setter.accept(c, (byte)0))).recover(Helper.adapt(e -> setter.accept(c, (short)0)));
                return null;
            };
        }

        private static <T, S> Function<T, S> adapt(Consumer<T> o) {
            return t -> {
                o.accept(t);
                return null;
            };
        }
    }
}

