/*
 * Decompiled with CFR 0.152.
 */
package xdean.reflect.getter.impl;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Function;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.NoOp;
import sun.misc.Unsafe;
import xdean.jex.extra.function.SupplierThrow;
import xdean.jex.util.lang.PrimitiveTypeUtil;
import xdean.jex.util.lang.UnsafeUtil;
import xdean.jex.util.reflect.ReflectUtil;
import xdean.jex.util.task.TaskUtil;
import xdean.reflect.getter.FieldGetter;

public class UnsafeFieldGetter<T>
implements FieldGetter<T> {
    private static final Unsafe UNSAFE = UnsafeUtil.getUnsafe();
    private T mockT;
    private Map<Object, Field> primitiveMap = new HashMap<Object, Field>();
    private Map<Object, Field> objectMap = new IdentityHashMap<Object, Field>();
    private short booleanCount = 0;
    private short byteCount = 0;
    private int charCount;
    private long intCount;
    private int shortCount;
    private long longCount;
    private long floatCount;
    private long doubleCount;

    public UnsafeFieldGetter(Class<T> clz) throws IllegalStateException, IllegalArgumentException {
        try {
            Field[] fields;
            if (clz.isInterface()) {
                throw new IllegalArgumentException("Interface has no field.");
            }
            this.mockT = Modifier.isAbstract(clz.getModifiers()) ? this.newAbstract(clz) : this.newObject(clz);
            for (Field field : fields = ReflectUtil.getAllFields(clz, (boolean)false)) {
                Class<?> type = field.getType();
                if (PrimitiveTypeUtil.isPrimitive(type)) {
                    this.handlePrimitive(field);
                    continue;
                }
                if (type.isArray()) {
                    this.handleArray(field);
                    continue;
                }
                this.handleObject(field);
            }
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e);
        }
    }

    private void handleObject(Field field) throws InstantiationException {
        Class<?> type = field.getType();
        Object o = type.isInterface() || Modifier.isAbstract(type.getModifiers()) ? this.newAbstract(type) : (type == Class.class ? this.newClass(Object.class) : this.newObject(type));
        long offset = UNSAFE.objectFieldOffset(field);
        UNSAFE.putObject(this.mockT, offset, o);
        this.objectMap.put(o, field);
    }

    private <C> C newObject(Class<C> clz) throws InstantiationException {
        return (C)UNSAFE.allocateInstance(clz);
    }

    private <C> C newAbstract(Class<C> clz) throws InstantiationException {
        return this.newObject(this.newClass(clz));
    }

    private <C> Class<? extends C> newClass(Class<C> clz) {
        Enhancer enhancer = new Enhancer();
        if (clz.isInterface()) {
            enhancer.setInterfaces(new Class[]{clz});
        } else {
            enhancer.setSuperclass(clz);
        }
        enhancer.setUseCache(true);
        enhancer.setCallbackType(NoOp.class);
        return enhancer.createClass();
    }

    private void handleArray(Field field) {
        Array.newInstance(field.getType(), 0);
        long offset = UNSAFE.objectFieldOffset(field);
        Object array = Array.newInstance(Object.class, 0);
        UNSAFE.putObject(this.mockT, offset, array);
        this.objectMap.put(array, field);
    }

    private void handlePrimitive(Field field) {
        switch (field.getType().getName()) {
            case "int": {
                this.handleInt(field);
                break;
            }
            case "short": {
                this.handleShort(field);
                break;
            }
            case "long": {
                this.handleLong(field);
                break;
            }
            case "double": {
                this.handleDouble(field);
                break;
            }
            case "float": {
                this.handleFloat(field);
                break;
            }
            case "boolean": {
                this.handleBoolean(field);
                break;
            }
            case "char": {
                this.handleChar(field);
                break;
            }
            case "byte": {
                this.handleByte(field);
                break;
            }
            default: {
                throw new IllegalArgumentException("Not a primitive type.");
            }
        }
    }

    private void handleBoolean(Field field) {
        this.checkRange(field, 1, this.booleanCount);
        long offset = UNSAFE.objectFieldOffset(field);
        boolean bool = this.booleanCount == 0;
        UNSAFE.putBoolean(this.mockT, offset, bool);
        this.primitiveMap.put(bool, field);
        this.booleanCount = (short)(this.booleanCount + 1);
    }

    private void handleByte(Field field) {
        this.checkRange(field, 8, this.byteCount);
        long offset = UNSAFE.objectFieldOffset(field);
        byte b = (byte)this.byteCount;
        UNSAFE.putByte(this.mockT, offset, b);
        this.primitiveMap.put(b, field);
        this.byteCount = (short)(this.byteCount + 1);
    }

    private void handleChar(Field field) {
        this.checkRange(field, 16, this.charCount);
        long offset = UNSAFE.objectFieldOffset(field);
        char i = (char)this.charCount;
        UNSAFE.putInt(this.mockT, offset, i);
        this.primitiveMap.put(Character.valueOf(i), field);
        ++this.charCount;
    }

    private void handleInt(Field field) {
        this.checkRange(field, 32, this.intCount);
        long offset = UNSAFE.objectFieldOffset(field);
        int i = (int)this.intCount;
        UNSAFE.putInt(this.mockT, offset, i);
        this.primitiveMap.put(i, field);
        ++this.intCount;
    }

    private void handleShort(Field field) {
        this.checkRange(field, 16, this.shortCount);
        long offset = UNSAFE.objectFieldOffset(field);
        short i = (short)this.shortCount;
        UNSAFE.putShort(this.mockT, offset, i);
        this.primitiveMap.put(i, field);
        ++this.shortCount;
    }

    private void handleLong(Field field) {
        this.checkRange(field, 64, this.longCount);
        long offset = UNSAFE.objectFieldOffset(field);
        long l = this.longCount++;
        UNSAFE.putLong(this.mockT, offset, l);
        this.primitiveMap.put(l, field);
    }

    private void handleFloat(Field field) {
        this.checkRange(field, 32, this.floatCount);
        long offset = UNSAFE.objectFieldOffset(field);
        float f = Float.intBitsToFloat((int)this.floatCount);
        UNSAFE.putFloat(this.mockT, offset, f);
        this.primitiveMap.put(Float.valueOf(f), field);
        ++this.floatCount;
    }

    private void handleDouble(Field field) {
        this.checkRange(field, 64, this.doubleCount);
        long offset = UNSAFE.objectFieldOffset(field);
        double d = Double.longBitsToDouble(this.doubleCount);
        UNSAFE.putDouble(this.mockT, offset, d);
        this.primitiveMap.put(d, field);
        ++this.doubleCount;
    }

    private void checkRange(Field field, int bits, short currentCount) {
        this.checkRange(field, bits, Short.toUnsignedLong(currentCount));
    }

    private void checkRange(Field field, int bits, int currentCount) {
        this.checkRange(field, bits, Integer.toUnsignedLong(currentCount));
    }

    private void checkRange(Field field, int bits, long currentCount) {
        if (bits < 64 && currentCount == 1L << bits || currentCount == -1L) {
            throw this.getException(field, bits);
        }
    }

    private RuntimeException getException(Field field, int bits) {
        Class<?> type = field.getType();
        return new IllegalArgumentException(String.format("Can't generate %s preoperty (%s)'s name getter, only support %s %ss.", type.getName(), field.getName(), 1L << bits, type.getName()));
    }

    public T getMockObject() {
        return this.mockT;
    }

    @Override
    public boolean supportFieldInvoke() {
        return true;
    }

    @Override
    public Field get(Function<T, ?> invoke) {
        return this.get(invoke.apply(this.getMockObject()));
    }

    public Field get(Object o) {
        return (Field)TaskUtil.firstNonNull((SupplierThrow[])new SupplierThrow[]{() -> this.objectMap.get(o), () -> this.primitiveMap.get(o)}).orElseThrow(() -> new IllegalStateException("The given value isn't the mock object's property."));
    }

    public String getName(Object o) {
        return this.get(o).getName();
    }

    public Class<?> getType(Object o) {
        return this.get(o).getType();
    }

    public String nameOf(Object o) {
        return this.getName(o);
    }

    public Class<?> typeOf(Object o) {
        return this.getType(o);
    }
}

