/*
 * Decompiled with CFR 0.152.
 */
package xdean.reflect.getter;

import java.lang.reflect.Method;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import xdean.reflect.getter.InvokeGetter;
import xdean.reflect.getter.PropertyGetter;
import xdean.reflect.getter.internal.util.TaskUtil;

public interface MethodGetter<T>
extends InvokeGetter<T, Method>,
PropertyGetter<T> {
    public static final int UP_LOW_GAP = 32;

    @Override
    default public <O> Method get(BiConsumer<T, O> setter) {
        return (Method)this.get(Helper.setterToFunction(setter));
    }

    @Override
    default public String getName(Function<T, ?> invoke) {
        String name = ((Method)this.get(invoke)).getName();
        return (String)Optional.ofNullable(TaskUtil.firstSuccess(() -> Helper.getterToName(name), () -> Helper.setterToName(name))).orElseThrow(() -> new IllegalArgumentException("Can't get property name from method name: " + name));
    }

    @Override
    default public <O> String getName(BiConsumer<T, O> setter) {
        return this.getName(Helper.setterToFunction(setter));
    }

    @Override
    default public Class<?> getType(Function<T, ?> invoke) {
        return ((Method)this.get(invoke)).getReturnType();
    }

    @Override
    default public <O> Class<?> getType(BiConsumer<T, O> setter) {
        return this.getType(Helper.setterToFunction(setter));
    }

    @Override
    default public <O> String nameOf(BiConsumer<T, O> setter) {
        return this.nameOf(Helper.setterToFunction(setter));
    }

    @Override
    default public <O> Class<?> typeOf(BiConsumer<T, O> setter) {
        return this.typeOf(Helper.setterToFunction(setter));
    }

    public static class Helper {
        private static String getterToName(String getterName) {
            if (getterName.startsWith("get") && getterName.length() > 3) {
                return (char)(getterName.charAt(3) + 32) + getterName.substring(4);
            }
            if (getterName.startsWith("is") && getterName.length() > 2) {
                return (char)(getterName.charAt(2) + 32) + getterName.substring(3);
            }
            throw new IllegalArgumentException("Getter method name must be (get|is)XxxXxx, but was \"" + getterName + "\".");
        }

        private static String setterToName(String setterName) {
            if (setterName.startsWith("set") && setterName.length() > 3) {
                return (char)(setterName.charAt(3) + 32) + setterName.substring(4);
            }
            throw new IllegalArgumentException("Setter method name must be (get|is)XxxXxx, but was \"" + setterName + "\".");
        }

        private static <T, V> Function<T, ?> setterToFunction(BiConsumer<T, V> setter) {
            return c -> {
                TaskUtil.firstSuccess(() -> setter.accept(c, null), () -> setter.accept(c, 0), () -> setter.accept(c, 0.0), () -> setter.accept(c, false), () -> setter.accept(c, Float.valueOf(0.0f)), () -> setter.accept(c, 0L), () -> setter.accept(c, Character.valueOf('0')), () -> setter.accept(c, (byte)0), () -> setter.accept(c, (short)0));
                return null;
            };
        }
    }
}

