/*
 * Decompiled with CFR 0.152.
 */
package xdean.reflect.getter.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Optional;
import java.util.function.Function;
import net.sf.cglib.core.Signature;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import xdean.reflect.getter.MethodGetter;
import xdean.reflect.getter.internal.util.ReflectUtil;
import xdean.reflect.getter.internal.util.UnsafeUtil;

public class ProxyMethodGetter<T>
implements MethodGetter<T> {
    private static final String BIND_CALLBACK;
    private static final ThreadLocal<Method> LAST_METHOD;
    private T mockT;

    private static Optional<Method> getMethod() {
        return Optional.ofNullable(LAST_METHOD.get());
    }

    private static void putMethod(Method invocation) {
        LAST_METHOD.set(invocation);
    }

    private static Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) {
        ProxyMethodGetter.putMethod(method);
        return null;
    }

    public ProxyMethodGetter(Class<T> clz) throws IllegalStateException {
        try {
            if (Modifier.isFinal(clz.getModifiers())) {
                throw new IllegalArgumentException("Can't mock final class.");
            }
            Enhancer e = new Enhancer();
            e.setSuperclass(clz);
            e.setUseCache(true);
            e.setCallbackType(MethodInterceptor.class);
            Class createClass = e.createClass();
            Enhancer.registerCallbacks((Class)createClass, (Callback[])new Callback[]{ProxyMethodGetter::intercept});
            Object object = UnsafeUtil.getUnsafe().allocateInstance(createClass);
            Method bindMethod = createClass.getDeclaredMethod(BIND_CALLBACK, Object.class);
            bindMethod.setAccessible(true);
            bindMethod.invoke(null, object);
            this.mockT = object;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new Error("Never happen. Check code.", e);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e);
        }
    }

    public T getMockObject() {
        return this.mockT;
    }

    @Override
    public Method get(Function<T, ?> invoke) {
        return this.get(invoke.apply(this.getMockObject()));
    }

    public Method get(Object invoke) {
        return ProxyMethodGetter.getMethod().orElseThrow(() -> new IllegalArgumentException("No method invoked."));
    }

    public String getName(Object o) {
        return this.get(o).getName();
    }

    public Class<?> getType(Object o) {
        return this.get(o).getReturnType();
    }

    public String nameOf(Object o) {
        return this.getName(o);
    }

    public Class<?> typeOf(Object o) {
        return this.getType(o);
    }

    static {
        try {
            BIND_CALLBACK = ((Signature)ReflectUtil.getFieldValue(Enhancer.class, null, "BIND_CALLBACKS")).getName();
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException("Can't find Enhancer.BIND_CALLBACK field.", e);
        }
        LAST_METHOD = new ThreadLocal();
    }
}

