/*
 * Decompiled with CFR 0.152.
 */
package com.github.adminfaces.template.exception;

import com.github.adminfaces.template.exception.BusinessException;
import com.github.adminfaces.template.util.Assert;
import com.github.adminfaces.template.util.WebXml;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJBException;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.context.ExceptionHandler;
import javax.faces.context.ExceptionHandlerWrapper;
import javax.faces.context.FacesContext;
import javax.faces.event.ExceptionQueuedEvent;
import javax.faces.event.PhaseId;
import javax.servlet.http.HttpServletRequest;
import org.omnifaces.util.Exceptions;
import org.omnifaces.util.Messages;

public class CustomExceptionHandler
extends ExceptionHandlerWrapper {
    private static final Logger logger = Logger.getLogger(CustomExceptionHandler.class.getName());
    private ExceptionHandler wrapped;

    public CustomExceptionHandler(ExceptionHandler exceptionHandler) {
        this.wrapped = exceptionHandler;
    }

    public ExceptionHandler getWrapped() {
        return this.wrapped;
    }

    public void handle() throws FacesException {
        FacesContext context = FacesContext.getCurrentInstance();
        this.findErrorMessages(context);
        this.handleException(context);
        this.wrapped.handle();
    }

    private void handleException(FacesContext context) {
        Iterator unhandledExceptionQueuedEvents = this.getUnhandledExceptionQueuedEvents().iterator();
        if (unhandledExceptionQueuedEvents.hasNext()) {
            Throwable exception = ((ExceptionQueuedEvent)unhandledExceptionQueuedEvents.next()).getContext().getException();
            unhandledExceptionQueuedEvents.remove();
            Throwable rootCause = Exceptions.unwrap((Throwable)exception);
            if (rootCause instanceof BusinessException) {
                this.handleBusinessException(context, (BusinessException)rootCause);
                return;
            }
            this.goToErrorPage(context, rootCause);
        }
    }

    private void goToErrorPage(FacesContext context, Throwable e) {
        String errorPageParam;
        logger.log(Level.WARNING, "", e);
        if (e instanceof FileNotFoundException) {
            throw new FacesException(e);
        }
        HttpServletRequest request = (HttpServletRequest)context.getExternalContext().getRequest();
        Map sessionMap = context.getExternalContext().getSessionMap();
        String referer = request.getHeader("Referer");
        sessionMap.put("userAgent", request.getHeader("user-agent"));
        sessionMap.put("requestedUri", Assert.has(referer) ? referer : request.getRequestURL());
        sessionMap.put("stacktrace", e);
        sessionMap.put("errorMessage", e != null ? e.getMessage() : "");
        sessionMap.put("exceptionType", e != null ? e.getClass().getName() : null);
        String userIp = request.getHeader("x-forwarded-for") != null ? request.getHeader("x-forwarded-for").split(",")[0] : request.getRemoteAddr();
        sessionMap.put("userIp", userIp);
        String errorPage = this.findErrorPage(e);
        if (!Assert.has(errorPage) && !Assert.has(errorPageParam = context.getExternalContext().getInitParameter("com.github.adminfaces.ERROR_PAGE"))) {
            errorPage = "500.xhtml";
        }
        try {
            context.getExternalContext().redirect(context.getExternalContext().getRequestContextPath() + errorPage);
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "Could not redirect user to error page: " + context.getExternalContext().getRequestContextPath() + errorPage, ex);
        }
    }

    private String findErrorPage(Throwable exception) {
        if (exception instanceof EJBException && exception.getCause() != null) {
            exception = exception.getCause();
        }
        String errorPage = WebXml.INSTANCE.findErrorPageLocation(exception);
        return errorPage;
    }

    private void handleBusinessException(FacesContext context, BusinessException e) {
        if (context.getCurrentPhaseId() == PhaseId.RENDER_RESPONSE) {
            throw new FacesException((Throwable)e);
        }
        if (Assert.has(e.getExceptionList())) {
            for (BusinessException be : e.getExceptionList()) {
                this.addFacesMessage(be);
            }
        } else {
            this.addFacesMessage(e);
        }
        this.validationFailed(context);
        context.renderResponse();
    }

    private void addFacesMessage(BusinessException be) {
        FacesMessage facesMessage = new FacesMessage();
        if (Assert.has(be.getSummary())) {
            facesMessage.setSummary(be.getSummary());
        }
        if (Assert.has(be.getDetail())) {
            facesMessage.setDetail(be.getDetail());
        }
        if (Assert.has(be.getSeverity())) {
            facesMessage.setSeverity(be.getSeverity());
        } else {
            facesMessage.setSeverity(FacesMessage.SEVERITY_ERROR);
        }
        Messages.add((String)be.getFieldId(), (FacesMessage)facesMessage);
    }

    private void validationFailed(FacesContext context) {
        HashMap<String, Boolean> callbackParams = (HashMap<String, Boolean>)context.getAttributes().get("CALLBACK_PARAMS");
        if (callbackParams == null) {
            callbackParams = new HashMap<String, Boolean>();
            callbackParams.put("CALLBACK_PARAMS", (Boolean)((Object)callbackParams));
        }
        callbackParams.put("validationFailed", true);
    }

    private void findErrorMessages(FacesContext context) {
        if (context.getMessageList().isEmpty() || context.isValidationFailed()) {
            return;
        }
        for (FacesMessage msg : context.getMessageList()) {
            if (!msg.getSeverity().equals(FacesMessage.SEVERITY_ERROR) && !msg.getSeverity().equals(FacesMessage.SEVERITY_FATAL)) continue;
            this.validationFailed(context);
            break;
        }
    }
}

