/*
 * Decompiled with CFR 0.152.
 */
package com.github.agogs.holidayapi.api.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.agogs.holidayapi.api.APIConsumer;
import com.github.agogs.holidayapi.model.HolidayAPIResponse;
import com.github.agogs.holidayapi.model.QueryParams;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HolidayAPIConsumer
implements APIConsumer {
    private static final Logger log = LogManager.getLogger(HolidayAPIConsumer.class);
    private String baseURl;

    public HolidayAPIConsumer(String baseURl) {
        log.debug("instantiating with base url : {}", (Object)baseURl);
        this.baseURl = baseURl;
    }

    @Override
    public HolidayAPIResponse getHolidays(QueryParams queryParams) throws IOException {
        log.info("get holidays API call with query params {}", (Object)queryParams.toString());
        String json = this.getHolidaysAsString(queryParams);
        log.info("got json string response");
        log.debug("got json string response : {}", (Object)json);
        ObjectMapper mapper = new ObjectMapper();
        HolidayAPIResponse response = (HolidayAPIResponse)mapper.readValue(json, HolidayAPIResponse.class);
        log.info("returning response");
        log.debug("returning response : {}", (Object)response);
        return response;
    }

    @Override
    public String getHolidaysAsString(QueryParams queryParams) throws IOException {
        log.info("get holidays API call with query params {}", (Object)queryParams.toString());
        log.info("constructing url with query param string");
        URL url = new URL(this.baseURl + "?" + queryParams.queryString());
        log.info("connecting to API endpoint");
        HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
        connection.connect();
        StringBuilder builder = new StringBuilder();
        BufferedReader bufferedReader = null;
        String line = null;
        int responseCode = connection.getResponseCode();
        log.info("response code : {}", (Object)responseCode);
        if (responseCode == 200) {
            log.info("preparing to read content from inputstream");
            bufferedReader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        } else {
            log.info("preparing to read content from errorstream");
            bufferedReader = new BufferedReader(new InputStreamReader(connection.getErrorStream()));
        }
        log.info("reading response content");
        while ((line = bufferedReader.readLine()) != null) {
            builder.append(line);
        }
        bufferedReader.close();
        String response = builder.toString();
        log.info("returning response string {}", (Object)response);
        return response;
    }
}

