/*
 * Decompiled with CFR 0.152.
 */
package com.github.agogs.holidayapi.model;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class QueryParams {
    private Map<String, Object> params = new HashMap<String, Object>();

    public QueryParams key(String key) {
        this.params.put(APIParameter.API_KEY.toString(), key);
        return this;
    }

    public QueryParams country(Country country) {
        this.params.put(APIParameter.COUNTRY.toString(), country.code());
        return this;
    }

    public QueryParams year(int year) {
        this.params.put(APIParameter.YEAR.toString(), year);
        return this;
    }

    public QueryParams month(int month) {
        this.params.put(APIParameter.MONTH.toString(), month);
        return this;
    }

    public QueryParams day(int day) {
        this.params.put(APIParameter.DAY.toString(), day);
        return this;
    }

    public QueryParams previous(boolean previous) {
        this.params.put(APIParameter.PREVIOUS.toString(), previous);
        return this;
    }

    public QueryParams upcoming(boolean upcoming) {
        this.params.put(APIParameter.UPCOMING.toString(), upcoming);
        return this;
    }

    public QueryParams isPublic(boolean isPublic) {
        this.params.put(APIParameter.PUBLIC.toString(), isPublic);
        return this;
    }

    public QueryParams format(Format format) {
        this.params.put(APIParameter.FORMAT.toString(), format.value);
        return this;
    }

    public QueryParams pretty(boolean pretty) {
        this.params.put(APIParameter.PRETTY.toString(), pretty);
        return this;
    }

    public String queryString() {
        if (this.params.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        Iterator<Map.Entry<String, Object>> it = this.params.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Object> e = it.next();
            builder.append((Object)e.getKey()).append("=").append(e.getValue());
            if (!it.hasNext()) continue;
            builder.append("&");
        }
        return builder.toString();
    }

    public String toString() {
        return this.queryString();
    }

    public static enum Format {
        STRING("string"),
        CSV("csv"),
        JSON("json"),
        PHP("php"),
        TSV("tsv"),
        YAML("yaml"),
        XML("xml");

        private String value;

        private Format(String value) {
            this.value = value;
        }

        public String format() {
            return this.value;
        }
    }

    public static enum Country {
        ARGENTINA("AR"),
        ANGOLA("AO"),
        AUSTRIA("AT"),
        AUSTRALIA("AU"),
        ARUBA("AW"),
        \u00c5LAND_ISLANDS("AX"),
        BOSNIA_AND_HERZEGOVINA("BA"),
        BELGIUM("BE"),
        BULGARIA("BG"),
        BOLIVIA("BO"),
        BRAZIL("BR"),
        THE_BHAMAS("BS"),
        CANADA("CA"),
        SWITZERLAND("CH"),
        CHINA("CN"),
        COLOMBIA("CO"),
        COSTA_RICA("CR"),
        CUBA("CU"),
        CZECH_REPUBLIC("CZ"),
        GERMANY("DE"),
        DENMARK("DK"),
        DOMINICAN_REPUBLIC("DO"),
        ECUADOR("EC"),
        SPAIN("ES"),
        FINLAND("FI"),
        FRANCE("FR"),
        UNITED_KINGDOM("GB"),
        ENGLAND("GB-ENG"),
        NORTHERN_IRELAND("GB-NIR"),
        SCOTLAND("GB-SCT"),
        WALES("GB-WLS"),
        GREECE("GR"),
        GUATEMALA("GT"),
        HONG_KONG("HK"),
        HONDURAS("HN"),
        CROATIA("HR"),
        HUNGARY("HU"),
        INDONESIA("ID"),
        IRELAND("IE"),
        INDIA("IN"),
        ISRAEL("IL"),
        ICELAND("IS"),
        ITALY("IT"),
        JAPAN("JP"),
        KAZAKHSTAN("KZ"),
        LESOTHO("LS"),
        LUXEMBOURG("LU"),
        MADAGASCAR("MG"),
        MARTINIQUE("MQ"),
        MALTA("MT"),
        MAURITIUS("MU"),
        MEXICO("MX"),
        MOZAMBIQUE("MZ"),
        NIGERIA("NG"),
        NETHERLANDS("NL"),
        NORWAY("NO"),
        PERU("PE"),
        PAKISTAN("PK"),
        PHILIPPINES("PH"),
        POLAND("PL"),
        PUERTO_RICO("PR"),
        PORTUGAL("PT"),
        PARAGUAY("PY"),
        R\u00e9UNION("RE"),
        ROMANIA("RO"),
        RUSSIA("RU"),
        SEYCHELLES("SC"),
        SWEDEN("SE"),
        SINGAPORE("SG"),
        SLOVENIA("SI"),
        SAO_TOME_AND_PRINCIPE("ST"),
        SLOVAKIA("SK"),
        TUNISIA("TN"),
        TURKEY("TR"),
        UKRAINE("UA"),
        UNITED_STATES("US"),
        URUGUAY("UY"),
        VENEZUELA("VE"),
        SOUTH_AFRICA("ZA"),
        ZIMBABWE("ZW");

        private String countryCode;

        private Country(String countryCode) {
            this.countryCode = countryCode;
        }

        public String code() {
            return this.countryCode;
        }
    }

    public static enum APIParameter {
        API_KEY("key"),
        COUNTRY("country"),
        YEAR("year"),
        MONTH("month"),
        DAY("day"),
        PREVIOUS("previous"),
        UPCOMING("upcoming"),
        PUBLIC("public"),
        FORMAT("format"),
        PRETTY("pretty");

        private String param;

        private APIParameter(String param) {
            this.param = param;
        }

        public String toString() {
            return this.param;
        }
    }
}

