/*
 * Decompiled with CFR 0.152.
 */
package ix.internal.operators;

import ix.internal.operators.Interactive;
import ix.internal.util.SingleContainer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import rx.Notification;
import rx.functions.Func2;

public final class AggregateIterable<T, U, V>
implements Iterable<V> {
    private final Iterable<? extends T> source;
    private final Func2<? super U, ? super T, ? extends U> sum;
    private final Func2<? super U, ? super Integer, ? extends V> divide;

    public AggregateIterable(Iterable<? extends T> source, Func2<? super U, ? super T, ? extends U> sum, Func2<? super U, ? super Integer, ? extends V> divide) {
        this.source = source;
        this.sum = sum;
        this.divide = divide;
    }

    @Override
    public Iterator<V> iterator() {
        return new Iterator<V>(){
            final Iterator<? extends T> it;
            final SingleContainer<Notification<? extends V>> result;
            boolean done;
            {
                this.it = AggregateIterable.this.source.iterator();
                this.result = new SingleContainer();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasNext() {
                if (!this.done) {
                    this.done = true;
                    if (this.result.isEmpty()) {
                        try {
                            Object intermediate = null;
                            int count = 0;
                            try {
                                while (this.it.hasNext()) {
                                    intermediate = AggregateIterable.this.sum.call(intermediate, this.it.next());
                                    ++count;
                                }
                            }
                            finally {
                                Interactive.unsubscribe(this.it);
                            }
                            if (count > 0) {
                                this.result.add(Interactive.some(AggregateIterable.this.divide.call(intermediate, (Object)count)));
                            }
                        }
                        catch (Throwable t) {
                            this.result.add(Interactive.err(t));
                        }
                    }
                }
                return !this.result.isEmpty();
            }

            @Override
            public V next() {
                if (this.hasNext()) {
                    return Interactive.value(this.result.take());
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

