/*
 * Decompiled with CFR 0.152.
 */
package ix.internal.operators;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import rx.functions.Func1;

public final class GenerateIterableTimed<T>
implements Iterable<T> {
    private final Func1<? super T, Boolean> predicate;
    private final Func1<? super T, ? extends T> next;
    private final T seed;
    private final long initialDelay;
    private final long betweenDelay;
    private final TimeUnit unit;

    public GenerateIterableTimed(Func1<? super T, Boolean> predicate, Func1<? super T, ? extends T> next, T seed, long initialDelay, long betweenDelay, TimeUnit unit) {
        this.predicate = predicate;
        this.next = next;
        this.seed = seed;
        this.initialDelay = initialDelay;
        this.betweenDelay = betweenDelay;
        this.unit = unit;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            T value;
            boolean shouldInitialWait;
            boolean shouldBetweenWait;
            {
                this.value = GenerateIterableTimed.this.seed;
                this.shouldInitialWait = true;
            }

            @Override
            public boolean hasNext() {
                if (this.shouldInitialWait) {
                    this.shouldInitialWait = false;
                    try {
                        GenerateIterableTimed.this.unit.sleep(GenerateIterableTimed.this.initialDelay);
                    }
                    catch (InterruptedException e) {
                        return false;
                    }
                }
                if (this.shouldBetweenWait) {
                    this.shouldBetweenWait = false;
                    try {
                        GenerateIterableTimed.this.unit.sleep(GenerateIterableTimed.this.betweenDelay);
                    }
                    catch (InterruptedException e) {
                        return false;
                    }
                }
                return (Boolean)GenerateIterableTimed.this.predicate.call(this.value);
            }

            @Override
            public T next() {
                if (this.hasNext()) {
                    this.shouldBetweenWait = true;
                    Object current = this.value;
                    this.value = GenerateIterableTimed.this.next.call(this.value);
                    return current;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

