/*
 * Decompiled with CFR 0.152.
 */
package ix.internal.operators;

import ix.internal.operators.Interactive;
import ix.internal.util.SingleContainer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import rx.exceptions.Exceptions;
import rx.functions.Func1;

public final class OnErrorResumeNextIterable<T>
implements Iterable<T> {
    private final Iterable<? extends T> source;
    private final Func1<? super Throwable, ? extends Iterable<? extends T>> handler;

    public OnErrorResumeNextIterable(Iterable<? extends T> source, Func1<? super Throwable, ? extends Iterable<? extends T>> handler) {
        this.source = source;
        this.handler = handler;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            Iterator<? extends T> it;
            Iterator<? extends T> itForRemove;
            final SingleContainer<T> peek;
            boolean usingHandler;
            {
                this.it = OnErrorResumeNextIterable.this.source.iterator();
                this.peek = new SingleContainer();
            }

            @Override
            public boolean hasNext() {
                if (this.peek.isEmpty()) {
                    while (!Thread.currentThread().isInterrupted()) {
                        try {
                            if (!this.it.hasNext()) break;
                            this.itForRemove = this.it;
                            this.peek.add(this.it.next());
                            break;
                        }
                        catch (Throwable t) {
                            if (!this.usingHandler) {
                                Interactive.unsubscribe(this.it);
                                this.it = ((Iterable)OnErrorResumeNextIterable.this.handler.call((Object)t)).iterator();
                                this.usingHandler = true;
                                continue;
                            }
                            Exceptions.propagate((Throwable)t);
                        }
                    }
                }
                return !this.peek.isEmpty();
            }

            @Override
            public T next() {
                if (this.hasNext()) {
                    return this.peek.take();
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                if (this.itForRemove == null) {
                    throw new IllegalStateException();
                }
                this.itForRemove.remove();
                this.itForRemove = null;
            }
        };
    }
}

