/*
 * Decompiled with CFR 0.152.
 */
package ix.internal.operators;

import ix.internal.operators.Interactive;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import rx.functions.Func1;

public final class OrderByIterable<T, U>
implements Iterable<T> {
    private final Iterable<? extends T> source;
    private final Comparator<? super U> keyComparator;
    private final Func1<? super T, ? extends U> keySelector;

    public OrderByIterable(Iterable<? extends T> source, Comparator<? super U> keyComparator, Func1<? super T, ? extends U> keySelector) {
        this.source = source;
        this.keyComparator = keyComparator;
        this.keySelector = keySelector;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            List<T> buffer;
            final Iterator<? extends T> it;
            Iterator<T> bufIterator;
            {
                this.it = OrderByIterable.this.source.iterator();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasNext() {
                if (this.buffer == null) {
                    this.buffer = new ArrayList();
                    try {
                        while (this.it.hasNext()) {
                            this.buffer.add(this.it.next());
                        }
                    }
                    finally {
                        Interactive.unsubscribe(this.it);
                    }
                    Collections.sort(this.buffer, new Comparator<T>(){

                        @Override
                        public int compare(T o1, T o2) {
                            Object key1 = OrderByIterable.this.keySelector.call(o1);
                            Object key2 = OrderByIterable.this.keySelector.call(o2);
                            return OrderByIterable.this.keyComparator.compare(key1, key2);
                        }
                    });
                    this.bufIterator = this.buffer.iterator();
                }
                return this.bufIterator.hasNext();
            }

            @Override
            public T next() {
                if (this.hasNext()) {
                    return this.bufIterator.next();
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

