/*
 * Decompiled with CFR 0.152.
 */
package ix.internal.operators;

import ix.Pair;
import ix.internal.operators.Interactive;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class SubsequentIterable<T>
implements Iterable<Pair<T, T>> {
    private final Iterable<? extends T> source;

    public SubsequentIterable(Iterable<? extends T> source) {
        this.source = source;
    }

    @Override
    public Iterator<Pair<T, T>> iterator() {
        final Iterator<T> it = this.source.iterator();
        if (!it.hasNext()) {
            return Interactive.empty().iterator();
        }
        final T flast = it.next();
        return new Iterator<Pair<T, T>>(){
            T last;
            {
                this.last = flast;
            }

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public Pair<T, T> next() {
                if (this.hasNext()) {
                    Object curr = it.next();
                    Pair ret = Pair.of(this.last, curr);
                    this.last = curr;
                    return ret;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

