/*
 * Decompiled with CFR 0.152.
 */
package ix.internal.operators;

import java.util.Iterator;
import java.util.NoSuchElementException;

public final class TakeIterable<T>
implements Iterable<T> {
    private final int num;
    private final Iterable<? extends T> source;

    public TakeIterable(int num, Iterable<? extends T> source) {
        this.num = num;
        this.source = source;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            int count;
            final Iterator<? extends T> it;
            {
                this.it = TakeIterable.this.source.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.count < TakeIterable.this.num && this.it.hasNext();
            }

            @Override
            public T next() {
                if (this.hasNext()) {
                    ++this.count;
                    return this.it.next();
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                this.it.remove();
            }
        };
    }
}

