/*
 * Decompiled with CFR 0.152.
 */
package ix.internal.util;

import rx.Notification;
import rx.exceptions.Exceptions;

public final class SingleOption<T> {
    protected boolean hasContent;
    protected T value;
    protected Throwable error;

    public void add(T value) {
        this.ensureEmpty();
        this.hasContent = true;
        this.value = value;
    }

    public void addError(Throwable ex) {
        this.ensureEmpty();
        this.hasContent = true;
        this.error = ex;
    }

    public boolean isEmpty() {
        return !this.hasContent;
    }

    protected void ensureEmpty() {
        if (this.hasContent) {
            throw new IllegalStateException("Full");
        }
    }

    protected void ensureFull() {
        if (!this.hasContent) {
            throw new IllegalStateException("Empty");
        }
    }

    public T take() {
        this.ensureFull();
        this.hasContent = false;
        Throwable t = this.error;
        if (t != null) {
            this.error = null;
            Exceptions.propagate((Throwable)t);
        }
        T result = this.value;
        this.value = null;
        return result;
    }

    public Throwable takeError() {
        this.ensureFull();
        Throwable t = this.error;
        if (t != null) {
            this.error = null;
            return t;
        }
        throw new IllegalStateException("no error");
    }

    public boolean hasError() {
        return this.hasContent && this.error != null;
    }

    public Notification<T> option() {
        if (this.hasContent) {
            Throwable t = this.error;
            if (t != null) {
                this.error = null;
                return Notification.createOnError((Throwable)t);
            }
            T v = this.value;
            this.value = null;
            return Notification.createOnNext(v);
        }
        return Notification.createOnCompleted();
    }

    public void addOption(Notification<? extends T> o) {
        if (o.isOnNext()) {
            this.add(o.getValue());
        } else if (o.isOnError()) {
            this.addError(o.getThrowable());
        } else {
            throw new IllegalArgumentException("OnCompleted Notification has no meaning here");
        }
    }
}

