/*
 * Decompiled with CFR 0.152.
 */
package ix.internal.operators;

import ix.internal.operators.Interactive;
import ix.internal.util.SingleContainer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import rx.Notification;

public final class CountIterable<T>
implements Iterable<Integer> {
    private final Iterable<T> source;

    public CountIterable(Iterable<T> source) {
        this.source = source;
    }

    @Override
    public Iterator<Integer> iterator() {
        final Iterator<T> it = this.source.iterator();
        return new Iterator<Integer>(){
            final SingleContainer<Notification<Integer>> peek = new SingleContainer();
            boolean done;

            @Override
            public boolean hasNext() {
                if (!this.done && this.peek.isEmpty()) {
                    int count = 0;
                    try {
                        while (it.hasNext()) {
                            it.next();
                            ++count;
                        }
                        this.peek.add(Interactive.some(count));
                    }
                    catch (Throwable t) {
                        this.peek.add(Interactive.err(t));
                    }
                    finally {
                        this.done = true;
                        Interactive.unsubscribe(it);
                    }
                }
                return !this.peek.isEmpty();
            }

            @Override
            public Integer next() {
                if (this.hasNext()) {
                    return Interactive.value(this.peek.take());
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

