/*
 * Decompiled with CFR 0.152.
 */
package ix.internal.operators;

import ix.internal.operators.Interactive;
import ix.internal.util.SingleContainer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import rx.Notification;
import rx.functions.Action0;
import rx.functions.Action1;

public final class DoOnEachIterable<T>
implements Iterable<T> {
    private final Action1<? super Throwable> error;
    private final Action0 finish;
    private final Iterable<? extends T> source;

    public DoOnEachIterable(Action1<? super Throwable> error, Action0 finish, Iterable<? extends T> source) {
        this.error = error;
        this.finish = finish;
        this.source = source;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            final Iterator<? extends T> it;
            final SingleContainer<Notification<? extends T>> peek;
            boolean once;
            {
                this.it = DoOnEachIterable.this.source.iterator();
                this.peek = new SingleContainer();
                this.once = true;
            }

            @Override
            public boolean hasNext() {
                if (this.peek.isEmpty()) {
                    try {
                        if (this.it.hasNext()) {
                            this.peek.add(Interactive.some(this.it.next()));
                        } else if (this.once) {
                            this.once = false;
                            DoOnEachIterable.this.finish.call();
                        }
                    }
                    catch (Throwable t) {
                        this.peek.add(Interactive.err(t));
                    }
                }
                return !this.peek.isEmpty();
            }

            @Override
            public T next() {
                if (this.it.hasNext()) {
                    Notification o = this.peek.take();
                    if (o.isOnError() && this.once) {
                        this.once = false;
                        DoOnEachIterable.this.error.call((Object)o.getThrowable());
                    }
                    return Interactive.value(o);
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                this.it.remove();
            }
        };
    }
}

