/*
 * Decompiled with CFR 0.152.
 */
package ix.internal.operators;

import ix.internal.operators.Interactive;
import ix.internal.util.SingleContainer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import rx.Notification;

public final class LongCountIterable<T>
implements Iterable<Long> {
    private final Iterable<T> source;

    public LongCountIterable(Iterable<T> source) {
        this.source = source;
    }

    @Override
    public Iterator<Long> iterator() {
        final Iterator<T> it = this.source.iterator();
        return new Iterator<Long>(){
            final SingleContainer<Notification<Long>> peek = new SingleContainer();
            boolean done;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasNext() {
                if (!this.done && this.peek.isEmpty()) {
                    long count = 0L;
                    try {
                        while (it.hasNext()) {
                            it.next();
                            ++count;
                        }
                        this.peek.add(Interactive.some(count));
                    }
                    catch (Throwable t) {
                        this.peek.add(Interactive.err(t));
                    }
                    finally {
                        this.done = true;
                        Interactive.unsubscribe(it);
                    }
                }
                return !this.peek.isEmpty();
            }

            @Override
            public Long next() {
                if (this.hasNext()) {
                    return Interactive.value(this.peek.take());
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

