/*
 * Decompiled with CFR 0.152.
 */
package ix.internal.operators;

import ix.internal.util.CircularBuffer;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class MemoizeIterable<T>
implements Iterable<T> {
    private final int bufferSize;
    Iterator<? extends T> it;
    final CircularBuffer<T> buffer;

    public MemoizeIterable(Iterable<? extends T> source, int bufferSize) {
        this.bufferSize = bufferSize;
        this.it = source.iterator();
        this.buffer = new CircularBuffer(bufferSize);
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            int myHead;

            @Override
            public boolean hasNext() {
                return MemoizeIterable.this.buffer.tail() > Math.max(this.myHead, MemoizeIterable.this.buffer.head()) || MemoizeIterable.this.it.hasNext();
            }

            @Override
            public T next() {
                if (this.hasNext()) {
                    if (MemoizeIterable.this.buffer.tail() == this.myHead) {
                        Object value = MemoizeIterable.this.it.next();
                        if (MemoizeIterable.this.bufferSize > 0) {
                            MemoizeIterable.this.buffer.add(value);
                        }
                        ++this.myHead;
                        return value;
                    }
                    this.myHead = Math.max(this.myHead, MemoizeIterable.this.buffer.head());
                    Object value = MemoizeIterable.this.buffer.get(this.myHead);
                    ++this.myHead;
                    return value;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

