/*
 * Decompiled with CFR 0.152.
 */
package ix.internal.operators;

import ix.internal.operators.Interactive;
import ix.internal.util.SingleContainer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import rx.Notification;

public final class OnErrorResumeNext<T>
implements Iterable<T> {
    private final Iterable<? extends Iterable<? extends T>> sources;

    public OnErrorResumeNext(Iterable<? extends Iterable<? extends T>> sources) {
        this.sources = sources;
    }

    @Override
    public Iterator<T> iterator() {
        final Iterator<Iterable<T>> iter0 = this.sources.iterator();
        if (iter0.hasNext()) {
            return new Iterator<T>(){
                Iterator<? extends T> it;
                Iterator<? extends T> itForRemove;
                final SingleContainer<Notification<? extends T>> peek;
                {
                    this.it = ((Iterable)iter0.next()).iterator();
                    this.itForRemove = null;
                    this.peek = new SingleContainer();
                }

                @Override
                public boolean hasNext() {
                    if (this.peek.isEmpty()) {
                        while (!Thread.currentThread().isInterrupted()) {
                            try {
                                if (this.it.hasNext()) {
                                    this.peek.add(Interactive.some(this.it.next()));
                                    break;
                                }
                                if (!iter0.hasNext()) break;
                                this.it = ((Iterable)iter0.next()).iterator();
                            }
                            catch (Throwable t) {
                                if (iter0.hasNext()) {
                                    this.it = ((Iterable)iter0.next()).iterator();
                                    continue;
                                }
                                this.peek.add(Interactive.err(t));
                                break;
                            }
                        }
                    }
                    return !this.peek.isEmpty();
                }

                @Override
                public T next() {
                    if (this.hasNext()) {
                        this.itForRemove = this.it;
                        return Interactive.value(this.peek.take());
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    if (this.itForRemove == null) {
                        throw new IllegalStateException();
                    }
                    this.itForRemove.remove();
                    this.itForRemove = null;
                }
            };
        }
        return Interactive.empty().iterator();
    }
}

