/*
 * Decompiled with CFR 0.152.
 */
package ix.internal.operators;

import java.util.Iterator;
import java.util.NoSuchElementException;

public final class PartialIterable<T>
implements Iterable<T> {
    private final int from;
    private final T[] ts;
    private final int to;

    public PartialIterable(int from, T[] ts, int to) {
        this.from = from;
        this.ts = ts;
        this.to = to;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            int index;
            final int size;
            {
                this.index = PartialIterable.this.from;
                this.size = PartialIterable.this.ts.length;
            }

            @Override
            public boolean hasNext() {
                return this.index < this.size && this.index < PartialIterable.this.to;
            }

            @Override
            public T next() {
                if (this.hasNext()) {
                    return PartialIterable.this.ts[this.index++];
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

