/*
 * Decompiled with CFR 0.152.
 */
package ix.internal.operators;

import ix.internal.operators.Interactive;
import ix.internal.util.CircularBuffer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import rx.Notification;

public final class SkipLastIterable<T>
implements Iterable<T> {
    private final Iterable<? extends T> source;
    private final int num;

    public SkipLastIterable(Iterable<? extends T> source, int num) {
        this.source = source;
        this.num = num;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            final Iterator<? extends T> it;
            final CircularBuffer<Notification<? extends T>> buffer;
            {
                this.it = SkipLastIterable.this.source.iterator();
                this.buffer = new CircularBuffer(SkipLastIterable.this.num);
            }

            @Override
            public boolean hasNext() {
                try {
                    while (this.buffer.size() < SkipLastIterable.this.num && this.it.hasNext()) {
                        this.buffer.add(Interactive.some(this.it.next()));
                    }
                }
                catch (Throwable t) {
                    this.buffer.add(Interactive.err(t));
                }
                finally {
                    Interactive.unsubscribe(this.it);
                }
                return this.buffer.size() == SkipLastIterable.this.num && this.it.hasNext();
            }

            @Override
            public T next() {
                if (this.hasNext()) {
                    return Interactive.value(this.buffer.take());
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

