/*
 * Decompiled with CFR 0.152.
 */
package ix.internal.operators;

import ix.CloseableIterator;
import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import rx.functions.Func0;
import rx.functions.Func1;

public final class UsingIterable<T, U extends Closeable>
implements Iterable<T> {
    private final Func0<U> resource;
    private final Func1<? super U, Iterable<? extends T>> usage;

    public UsingIterable(Func0<U> resource, Func1<? super U, Iterable<? extends T>> usage) {
        this.resource = resource;
        this.usage = usage;
    }

    @Override
    public Iterator<T> iterator() {
        final Closeable c = (Closeable)this.resource.call();
        return new CloseableIterator<T>(){
            final Iterator<? extends T> it;
            final AtomicBoolean once;
            {
                this.it = ((Iterable)UsingIterable.this.usage.call((Object)c)).iterator();
                this.once = new AtomicBoolean();
            }

            @Override
            public boolean hasNext() {
                if (this.it.hasNext()) {
                    return true;
                }
                this.unsubscribe();
                return false;
            }

            public boolean isUnsubscribed() {
                return this.once.get();
            }

            @Override
            public T next() {
                if (this.hasNext()) {
                    return this.it.next();
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                this.it.remove();
            }

            public void unsubscribe() {
                if (this.once.compareAndSet(false, true)) {
                    try {
                        c.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        };
    }
}

