/*
 * Decompiled with CFR 0.152.
 */
package ix.internal.util;

import ix.CloseableIterator;
import ix.internal.util.SingleOption;
import java.util.NoSuchElementException;
import rx.Observer;
import rx.Subscription;

public abstract class ObserverToIteratorSink<T, U>
implements Observer<T>,
CloseableIterator<U> {
    protected boolean done;
    protected final Subscription handle;
    protected final SingleOption<U> current = new SingleOption();

    public ObserverToIteratorSink(Subscription handle) {
        this.handle = handle;
    }

    @Override
    public boolean hasNext() {
        if (!this.done) {
            if (this.current.isEmpty() && !this.tryNext(this.current)) {
                this.done = true;
                this.unsubscribe();
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public U next() {
        if (this.hasNext()) {
            if (this.current.hasError()) {
                this.done = true;
                this.unsubscribe();
            }
            return this.current.take();
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void unsubscribe() {
        this.handle.unsubscribe();
    }

    public boolean isUnsubscribed() {
        return this.handle.isUnsubscribed();
    }

    protected void done() {
        this.unsubscribe();
    }

    public abstract boolean tryNext(SingleOption<? super U> var1);
}

