/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.flowable.internal.operators;

import io.reactivex.common.Notification;
import io.reactivex.common.RxJavaCommonPlugins;
import io.reactivex.common.internal.utils.BlockingHelper;
import io.reactivex.common.internal.utils.ExceptionHelper;
import io.reactivex.flowable.Flowable;
import io.reactivex.flowable.subscribers.DisposableSubscriber;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;

public final class BlockingFlowableLatest<T>
implements Iterable<T> {
    final Publisher<? extends T> source;

    public BlockingFlowableLatest(Publisher<? extends T> source) {
        this.source = source;
    }

    @Override
    public Iterator<T> iterator() {
        LatestSubscriberIterator lio = new LatestSubscriberIterator();
        Flowable.fromPublisher(this.source).materialize().subscribe(lio);
        return lio;
    }

    static final class LatestSubscriberIterator<T>
    extends DisposableSubscriber<Notification<T>>
    implements Iterator<T> {
        final Semaphore notify = new Semaphore(0);
        final AtomicReference<Notification<T>> value = new AtomicReference();
        Notification<T> iteratorNotification;

        LatestSubscriberIterator() {
        }

        public void onNext(Notification<T> args) {
            boolean wasNotAvailable;
            boolean bl = wasNotAvailable = this.value.getAndSet(args) == null;
            if (wasNotAvailable) {
                this.notify.release();
            }
        }

        public void onError(Throwable e) {
            RxJavaCommonPlugins.onError((Throwable)e);
        }

        public void onComplete() {
        }

        @Override
        public boolean hasNext() {
            if (this.iteratorNotification != null && this.iteratorNotification.isOnError()) {
                throw ExceptionHelper.wrapOrThrow((Throwable)this.iteratorNotification.getError());
            }
            if ((this.iteratorNotification == null || this.iteratorNotification.isOnNext()) && this.iteratorNotification == null) {
                Notification n;
                try {
                    BlockingHelper.verifyNonBlocking();
                    this.notify.acquire();
                }
                catch (InterruptedException ex) {
                    this.dispose();
                    this.iteratorNotification = Notification.createOnError((Throwable)ex);
                    throw ExceptionHelper.wrapOrThrow((Throwable)ex);
                }
                this.iteratorNotification = n = (Notification)this.value.getAndSet(null);
                if (n.isOnError()) {
                    throw ExceptionHelper.wrapOrThrow((Throwable)n.getError());
                }
            }
            return this.iteratorNotification.isOnNext();
        }

        @Override
        public T next() {
            if (this.hasNext() && this.iteratorNotification.isOnNext()) {
                Object v = this.iteratorNotification.getValue();
                this.iteratorNotification = null;
                return (T)v;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Read-only iterator.");
        }
    }
}

