/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.flowable.internal.operators;

import io.reactivex.common.exceptions.Exceptions;
import io.reactivex.common.internal.functions.ObjectHelper;
import io.reactivex.flowable.Flowable;
import io.reactivex.flowable.internal.subscriptions.EmptySubscription;
import java.util.concurrent.Callable;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

public final class FlowableDefer<T>
extends Flowable<T> {
    final Callable<? extends Publisher<? extends T>> supplier;

    public FlowableDefer(Callable<? extends Publisher<? extends T>> supplier) {
        this.supplier = supplier;
    }

    @Override
    public void subscribeActual(Subscriber<? super T> s) {
        Publisher pub;
        try {
            pub = (Publisher)ObjectHelper.requireNonNull(this.supplier.call(), (String)"The publisher supplied is null");
        }
        catch (Throwable t) {
            Exceptions.throwIfFatal((Throwable)t);
            EmptySubscription.error(t, s);
            return;
        }
        pub.subscribe(s);
    }
}

