/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.flowable.internal.operators;

import hu.akarnokd.reactivestreams.extensions.RelaxedSubscriber;
import io.reactivex.common.Notification;
import io.reactivex.common.RxJavaCommonPlugins;
import io.reactivex.flowable.Flowable;
import io.reactivex.flowable.internal.operators.AbstractFlowableWithUpstream;
import io.reactivex.flowable.internal.subscriptions.SubscriptionHelper;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableDematerialize<T>
extends AbstractFlowableWithUpstream<Notification<T>, T> {
    public FlowableDematerialize(Flowable<Notification<T>> source) {
        super(source);
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        this.source.subscribe(new DematerializeSubscriber<T>(s));
    }

    static final class DematerializeSubscriber<T>
    implements RelaxedSubscriber<Notification<T>>,
    Subscription {
        final Subscriber<? super T> actual;
        boolean done;
        Subscription s;

        DematerializeSubscriber(Subscriber<? super T> actual) {
            this.actual = actual;
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
            }
        }

        public void onNext(Notification<T> t) {
            if (this.done) {
                if (t.isOnError()) {
                    RxJavaCommonPlugins.onError((Throwable)t.getError());
                }
                return;
            }
            if (t.isOnError()) {
                this.s.cancel();
                this.onError(t.getError());
            } else if (t.isOnComplete()) {
                this.s.cancel();
                this.onComplete();
            } else {
                this.actual.onNext(t.getValue());
            }
        }

        public void onError(Throwable t) {
            if (this.done) {
                RxJavaCommonPlugins.onError((Throwable)t);
                return;
            }
            this.done = true;
            this.actual.onError(t);
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.actual.onComplete();
        }

        public void request(long n) {
            this.s.request(n);
        }

        public void cancel() {
            this.s.cancel();
        }
    }
}

